/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run.providers.runProviders.impl;

import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.python.dap.run.DebugpyConfigUtilsKt;
import com.intellij.python.dap.run.DebugpyRunConfig;
import com.intellij.python.dap.run.ModuleOrProgram;
import com.intellij.python.dap.run.providers.TypedDebugpyConfigProvider;
import com.intellij.util.system.OS;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/python/dap/run/providers/runProviders/impl/PythonRunConfigProvider;", "Lcom/intellij/python/dap/run/providers/TypedDebugpyConfigProvider;", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "<init>", "()V", "addCustomArgs", "Lcom/intellij/python/dap/run/DebugpyRunConfig;", "configuration", "commonConfig", "intellij.python.dap"})
public final class PythonRunConfigProvider
extends TypedDebugpyConfigProvider<PythonRunConfiguration> {
    public PythonRunConfigProvider() {
        super(Reflection.getOrCreateKotlinClass(PythonRunConfiguration.class));
    }

    @Override
    @NotNull
    public DebugpyRunConfig addCustomArgs(@NotNull PythonRunConfiguration configuration, @NotNull DebugpyRunConfig commonConfig) {
        ModuleOrProgram moduleOrProgram;
        String targetPath;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)commonConfig, (String)"commonConfig");
        if (configuration.isModuleMode()) {
            v0 = configuration.getScriptName();
        } else {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v0 = targetPath = ((Object)DebugpyConfigUtilsKt.getProgramPath(project, configuration.getScriptName(), configuration.getWorkingDirectory())).toString();
        }
        if (configuration.isModuleMode()) {
            Intrinsics.checkNotNull((Object)targetPath);
            moduleOrProgram = new ModuleOrProgram.Module(targetPath);
        } else {
            Intrinsics.checkNotNull((Object)targetPath);
            moduleOrProgram = new ModuleOrProgram.Program(targetPath);
        }
        ModuleOrProgram target = moduleOrProgram;
        commonConfig.setTarget(target.getPath());
        commonConfig.setTransport(OS.CURRENT != OS.Windows || WslPath.Companion.isWslUncPath(targetPath) ? "native" : "tcp");
        List<String> list = commonConfig.getArgs();
        List list2 = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)configuration.getScriptParameters());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expandMacrosAndParseParameters(...)");
        list.addAll(list2);
        return commonConfig;
    }
}

