/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.jinja.Jinja2TemplateUtil;
import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.DjangoTemplatePsiUtil;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EnterBetweenDjangoTagsHandler
implements EnterHandlerDelegate {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterBetweenDjangoTagsHandler.$$$reportNull$$$0(4);
        }
        if (file.getViewProvider() instanceof DjangoTemplateFileViewProvider && EnterBetweenDjangoTagsHandler.isBetweenTags(file.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE), editor, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenTags(PsiFile file, Editor editor, int offset) {
        DjangoTagElementImpl endTag;
        List list;
        if (file == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element == null || EnterBetweenDjangoTagsHandler.containsLineEnd(element)) {
            return false;
        }
        while ((element = element.getNextSibling()) instanceof PsiWhiteSpace && !EnterBetweenDjangoTagsHandler.containsLineEnd(element)) {
        }
        if (element instanceof OuterLanguageElement && !(list = PsiTreeUtil.getInjectedElements((OuterLanguageElement)((OuterLanguageElement)element))).isEmpty()) {
            element = (PsiElement)list.get(0);
        }
        if ((endTag = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class)) == null) {
            return false;
        }
        String endTagName = Jinja2TemplateUtil.getTagName((DjangoTagElementImpl)endTag);
        DjangoTagElementImpl prev = endTag;
        while ((prev = prev.getPrevSibling()) != null && DjangoTemplatePsiUtil.isWhiteSpaceOrComment((PsiElement)prev)) {
        }
        if (endTagName == null || !(prev instanceof DjangoTagElementImpl)) {
            return false;
        }
        DjangoTagElementImpl startTag = prev;
        TagLibrary lib = TagLibrary.getInstance((Project)startTag.getProject());
        return lib.isPair(startTag, endTag);
    }

    private static boolean containsLineEnd(PsiElement element) {
        return element.getText().contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/lang/template/editor/EnterBetweenDjangoTagsHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

