/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.javascript.microservices.JSUrlPathReferenceProviderKt;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlSegmentReferenceTarget;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/microservices/JSUrlPathReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "urlPathReferenceInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/intellij/lang/javascript/psi/JSExpression;", "<init>", "(Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;)V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "acceptsTarget", "", "target", "Companion", "intellij.javascript.langInjection"})
public final class JSUrlPathReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathReferenceInjector<JSExpression> urlPathReferenceInjector;
    @NotNull
    private static final Key<JSExpression> FULL_URL_EXPRESSION;
    @NotNull
    private static final Key<UrlPathContext> BASE_CONTEXT_PROVIDER;

    public JSUrlPathReferenceProvider(@NotNull UrlPathReferenceInjector<JSExpression> urlPathReferenceInjector) {
        Intrinsics.checkNotNullParameter(urlPathReferenceInjector, (String)"urlPathReferenceInjector");
        this.urlPathReferenceInjector = urlPathReferenceInjector;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JSExpression jSExpression = (JSExpression)context2.get(FULL_URL_EXPRESSION);
        if (jSExpression == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        JSExpression jsExpressionForFullUrl = jSExpression;
        Object[] fullReferences = this.urlPathReferenceInjector.buildFullUrlReference((Object)jsExpressionForFullUrl, element2);
        if (UrlPathReferenceInjector.Companion.hasConsistentFullUrl((PsiReference[])fullReferences) || this.urlPathReferenceInjector.hasCompleteScheme((Object)jsExpressionForFullUrl)) {
            return fullReferences;
        }
        List schemes = ((UrlPathContext)this.urlPathReferenceInjector.getDefaultRootContextProvider().invoke((Object)jsExpressionForFullUrl)).getSchemes();
        UrlPathContext urlPathContext = (UrlPathContext)context2.get(BASE_CONTEXT_PROVIDER);
        if (urlPathContext == null) {
            Pair<List<String>, String> pair = JSUrlPathReferenceProviderKt.detectSchemeAndMethod(jsExpressionForFullUrl);
            urlPathContext = UrlPathContext.Companion.supportingSchemes(schemes, pair != null ? (String)pair.getSecond() : null);
        }
        UrlPathContext urlPathContextProvider = urlPathContext;
        Object[] contextReferences = this.urlPathReferenceInjector.buildReferences((Object)jsExpressionForFullUrl).withRootContextProvider(urlPathContextProvider).forPsiElement(element2);
        return (PsiReference[])ArraysKt.plus((Object[])fullReferences, (Object[])contextReferences);
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target instanceof UrlSegmentReferenceTarget;
    }

    static {
        Key key = Key.create((String)"FULL_URL_EXPRESSION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FULL_URL_EXPRESSION = key;
        Key key2 = Key.create((String)"BASE_CONTEXT_PROVIDER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        BASE_CONTEXT_PROVIDER = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/microservices/JSUrlPathReferenceProvider$Companion;", "", "<init>", "()V", "FULL_URL_EXPRESSION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/javascript/psi/JSExpression;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFULL_URL_EXPRESSION", "()Lcom/intellij/openapi/util/Key;", "BASE_CONTEXT_PROVIDER", "Lcom/intellij/microservices/url/references/UrlPathContext;", "getBASE_CONTEXT_PROVIDER", "intellij.javascript.langInjection"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JSExpression> getFULL_URL_EXPRESSION() {
            return FULL_URL_EXPRESSION;
        }

        @NotNull
        public final Key<UrlPathContext> getBASE_CONTEXT_PROVIDER() {
            return BASE_CONTEXT_PROVIDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

