/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.TypeScriptFixesReferenceErrorUpdater;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptUMDGlobalInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptUMDGlobalInspection.calcShortNameFromClass(TypeScriptUMDGlobalInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (node.getQualifier() != null || optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
                    return;
                }
                TypeScriptUMDGlobalInspection.processUnqualifiedReferenceExpression(holder, node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection$1", "visitJSReferenceExpression"));
            }
        };
    }

    private static void processUnqualifiedReferenceExpression(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        PsiElement element2;
        ResolveResult[] results;
        if (holder == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(2);
        }
        if (node == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(3);
        }
        if ((results = node.multiResolve(false)).length != 1) {
            return;
        }
        ResolveResult result2 = results[0];
        if (result2.isValidResult() && (element2 = result2.getElement()) instanceof TypeScriptGlobalModuleExportDeclaration) {
            TypeScriptUMDGlobalInspection.processGlobalModuleExportDeclaration(holder, node, (TypeScriptGlobalModuleExportDeclaration)element2);
        }
    }

    private static void processGlobalModuleExportDeclaration(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression context2, @NotNull TypeScriptGlobalModuleExportDeclaration exportDeclaration) {
        boolean isCurrentFileModule;
        if (holder == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(5);
        }
        if (exportDeclaration == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(6);
        }
        boolean bl = isCurrentFileModule = ES6PsiUtil.isExternalModule((PsiElement)context2.getContainingFile()) || DialectDetector.isJSX((PsiElement)context2);
        if (!holder.isOnTheFly() && !isCurrentFileModule) {
            return;
        }
        ProblemHighlightType type2 = isCurrentFileModule ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
        String name = exportDeclaration.getName();
        if (name == null) {
            return;
        }
        JSElement scope2 = ES6PsiUtil.getNonStrictExportScope((PsiElement)context2);
        if (scope2 == null) {
            return;
        }
        Collection<LocalQuickFix> fixes = TypeScriptFixesReferenceErrorUpdater.createFixes(name, (PsiElement)scope2, false);
        holder.registerProblem((PsiElement)context2, JavaScriptBundle.message((String)"typescript.reference.to.umd.global", (Object[])new Object[0]), type2, (LocalQuickFix[])fixes.toArray(LocalQuickFix[]::new));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processUnqualifiedReferenceExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processGlobalModuleExportDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

