/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.matchingrules.TelephoneNumberComparisonPolicy;
import com.unboundid.ldap.matchingrules.TelephoneNumberValidationPolicy;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TelephoneNumberMatchingRule
extends SimpleMatchingRule {
    @NotNull
    public static final String DEFAULT_COMPARISON_POLICY_PROPERTY = TelephoneNumberMatchingRule.class.getName() + ".defaultComparisonPolicy";
    @NotNull
    public static final String DEFAULT_VALIDATION_POLICY_PROPERTY = TelephoneNumberMatchingRule.class.getName() + ".defaultValidationPolicy";
    @NotNull
    private static TelephoneNumberComparisonPolicy DEFAULT_COMPARISON_POLICY;
    @NotNull
    private static TelephoneNumberValidationPolicy DEFAULT_VALIDATION_POLICY;
    @NotNull
    private static TelephoneNumberMatchingRule INSTANCE;
    @NotNull
    public static final String EQUALITY_RULE_NAME = "telephoneNumberMatch";
    @NotNull
    static final String LOWER_EQUALITY_RULE_NAME;
    @NotNull
    public static final String EQUALITY_RULE_OID = "2.5.13.20";
    @NotNull
    public static final String SUBSTRING_RULE_NAME = "telephoneNumberSubstringsMatch";
    @NotNull
    static final String LOWER_SUBSTRING_RULE_NAME;
    @NotNull
    public static final String SUBSTRING_RULE_OID = "2.5.13.21";
    private static final long serialVersionUID = -5463096544849211252L;
    @NotNull
    private final TelephoneNumberComparisonPolicy comparisonPolicy;
    @NotNull
    private final TelephoneNumberValidationPolicy validationPolicy;

    public TelephoneNumberMatchingRule() {
        this(DEFAULT_VALIDATION_POLICY, DEFAULT_COMPARISON_POLICY);
    }

    public TelephoneNumberMatchingRule(@NotNull TelephoneNumberValidationPolicy validationPolicy, @NotNull TelephoneNumberComparisonPolicy comparisonPolicy) {
        Validator.ensureNotNullWithMessage((Object)validationPolicy, "TelephoneNumberMatchingRule.validationPolicy must not be null.");
        Validator.ensureNotNullWithMessage((Object)comparisonPolicy, "TelephoneNumberMatchingRule.comparisonPolicy must not be null.");
        this.validationPolicy = validationPolicy;
        this.comparisonPolicy = comparisonPolicy;
    }

    @NotNull
    public static TelephoneNumberMatchingRule getInstance() {
        return INSTANCE;
    }

    @NotNull
    public TelephoneNumberValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    @NotNull
    public static TelephoneNumberValidationPolicy getDefaultValidationPolicy() {
        return DEFAULT_VALIDATION_POLICY;
    }

    public static synchronized void setDefaultValidationPolicy(@NotNull TelephoneNumberValidationPolicy defaultValidationPolicy) {
        Validator.ensureNotNullWithMessage((Object)defaultValidationPolicy, "TelephoneNumberMatchingRule.defaultValidationPolicy must not be null.");
        DEFAULT_VALIDATION_POLICY = defaultValidationPolicy;
        INSTANCE = new TelephoneNumberMatchingRule(DEFAULT_VALIDATION_POLICY, DEFAULT_COMPARISON_POLICY);
    }

    @NotNull
    public TelephoneNumberComparisonPolicy getComparisonPolicy() {
        return this.comparisonPolicy;
    }

    @NotNull
    public static TelephoneNumberComparisonPolicy getDefaultComparisonPolicy() {
        return DEFAULT_COMPARISON_POLICY;
    }

    public static synchronized void setDefaultComparisonPolicy(@NotNull TelephoneNumberComparisonPolicy defaultComparisonPolicy) {
        Validator.ensureNotNullWithMessage((Object)defaultComparisonPolicy, "TelephoneNumberMatchingRule.defaultComparisonPolicy must not be null.");
        DEFAULT_COMPARISON_POLICY = defaultComparisonPolicy;
        INSTANCE = new TelephoneNumberMatchingRule(DEFAULT_VALIDATION_POLICY, DEFAULT_COMPARISON_POLICY);
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        this.validationPolicy.validateValue(value, false);
        return this.comparisonPolicy.normalizeValue(value);
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        this.validationPolicy.validateValue(value, true);
        return this.comparisonPolicy.normalizeValue(value);
    }

    @NotNull
    static ObjectPair<TelephoneNumberValidationPolicy, TelephoneNumberComparisonPolicy> computeDefaultPolicies() {
        TelephoneNumberValidationPolicy validationPolicy = null;
        String validationPropertyValue = StaticUtils.getSystemProperty(DEFAULT_VALIDATION_POLICY_PROPERTY);
        if (validationPropertyValue != null) {
            String normalizedPropertyValue = validationPropertyValue.toUpperCase().replace('-', '_');
            for (TelephoneNumberValidationPolicy v : TelephoneNumberValidationPolicy.values()) {
                if (!v.name().equals(normalizedPropertyValue)) continue;
                validationPolicy = v;
                break;
            }
        }
        if (validationPolicy == null) {
            validationPolicy = TelephoneNumberValidationPolicy.ALLOW_NON_EMPTY_PRINTABLE_STRING;
        }
        TelephoneNumberComparisonPolicy comparisonPolicy = null;
        String comparisonPropertyValue = StaticUtils.getSystemProperty(DEFAULT_COMPARISON_POLICY_PROPERTY);
        if (comparisonPropertyValue != null) {
            String normalizedPropertyValue = comparisonPropertyValue.toUpperCase().replace('-', '_');
            for (TelephoneNumberComparisonPolicy v : TelephoneNumberComparisonPolicy.values()) {
                if (!v.name().equals(normalizedPropertyValue)) continue;
                comparisonPolicy = v;
                break;
            }
        }
        if (comparisonPolicy == null) {
            comparisonPolicy = TelephoneNumberComparisonPolicy.IGNORE_ALL_NON_NUMERIC_CHARACTERS;
        }
        return new ObjectPair<TelephoneNumberValidationPolicy, TelephoneNumberComparisonPolicy>(validationPolicy, comparisonPolicy);
    }

    static {
        ObjectPair<TelephoneNumberValidationPolicy, TelephoneNumberComparisonPolicy> defaultPolicyPair = TelephoneNumberMatchingRule.computeDefaultPolicies();
        DEFAULT_VALIDATION_POLICY = defaultPolicyPair.getFirst();
        DEFAULT_COMPARISON_POLICY = defaultPolicyPair.getSecond();
        INSTANCE = new TelephoneNumberMatchingRule(DEFAULT_VALIDATION_POLICY, DEFAULT_COMPARISON_POLICY);
        LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase(EQUALITY_RULE_NAME);
        LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase(SUBSTRING_RULE_NAME);
    }
}

