/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum JSONLogMessages {
    ERR_INTERMEDIATE_RESPONSE_CANNOT_IDENTIFY_OPERATION_TYPE("Unable to identify the operation type for intermediate response log message {0}."),
    ERR_JSON_ACCESS_LOG_READER_MISSING_MESSAGE_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the required ''{1}'' field to indicate the type of log message that was read."),
    ERR_JSON_ACCESS_LOG_READER_MISSING_OPERATION_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it is missing the expected ''{1}'' field to indicate the type of operation being processed."),
    ERR_JSON_ACCESS_LOG_READER_NOT_VALID_JSON("The JSON-formatted access log data includes content that could not be parsed as a valid JSON object:  {0}"),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_ASSURANCE_COMPLETED_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for assurance completed log messages."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward failed log messages."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for forward log messages."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_MESSAGE_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported message type of ''{1}''."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_OPERATION_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an unsupported operation type of ''{1}''."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_REQUEST_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for request log messages."),
    ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_RESULT_OP_TYPE("Unable to parse JSON object {0} as a valid JSON-formatted access log message because it has an operation type of {1}, which is not supported for result log messages."),
    ERR_JSON_LOG_MESSAGE_MALFORMED_TIMESTAMP("Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field cannot be parsed as a timestamp in the ISO 8601 format described in RFC 3339."),
    ERR_JSON_LOG_MESSAGE_MISSING_TIMESTAMP("Unable to parse JSON object {0} as a JSON-formatted log message because it is missing the mandatory ''{1}'' field."),
    ERR_JSON_LOG_MESSAGE_TIMESTAMP_NOT_STRING("Unable to parse JSON object {0} as a JSON-formatted log message because the value of the ''{1}'' field is not a string."),
    ERR_JSON_LOG_MESSAGE_VALUE_NOT_BOOLEAN("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a Boolean."),
    ERR_JSON_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a floating-point number."),
    ERR_JSON_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the generalized time format."),
    ERR_JSON_LOG_MESSAGE_VALUE_NOT_INTEGER("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as an integer."),
    ERR_JSON_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIME("Unable to parse the value of field ''{0}'' in JSON-formatted log message {1} as a timestamp in the ISO 8601 format described in RFC 3339.");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<JSONLogMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<JSONLogMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private JSONLogMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-json-log");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

