%% Readserver uses socket_select with multiple read sockets.
%% Readclient writes to those sockets.

:- compiler_options([xpp_on]).
#include "socket_defs_xsb.h"
#include "timer_defs_xsb.h"
#include "char_defs.h"

:- ['auxdefs'].
:- import tryN/5 from auxdefs.

:- import 
     socket/2, socket_connect/4, socket_set_option/3,
     socket_close/2, socket_get0/3, socket_put/3  from socket.
:- import file_close/1 from file_io.


%% machine where server is running
machine(localhost).
%% Try something else:
%%machine(compserv1).

%% Port on which the server is listening
%% Server must bind to this port
xsb_port(6021).

client :-
	writeln('started client...'),
	machine(IPAddrOrHostname),
	xsb_port(XSB_port),
	tryN(4,
	     try_connect(Sockfd0 ,XSB_port, IPAddrOrHostname, Ecode2),
	     (writeln(sock_connect1(Sockfd0,XSB_port,IPAddrOrHostname,Ecode2)),
	     writeln('connected to server...')),
	     writeln('Cannot connect to server'),
	     Ecode2
	    ),
	
	%% Socket for reading replies
	try_connect(Sockfd1, XSB_port, IPAddrOrHostname, Ecode3),
	(Ecode3 < 0
	-> writeln('Cannot connect to server'),
	   socket_close(Sockfd0,_), socket_close(Sockfd1,_), fail
	; true),
        writeln(socket_connect2(Sockfd1,XSB_port,IPAddrOrHostname,Ecode3)),
	client_loop(Sockfd0, Sockfd1).

client :- writeln('Client error: exiting...').


client_loop(Sockfd0, Sockfd1) :-  
  nl, write('Please enter a character string. ^D terminates: '),
  get0(Char),
  writeln(Char),
  ((Char == CH_EOF_P; Char == 4; Char == CH_EOF_C) ->
      !,
      socket_put(Sockfd0, CH_EOF_C,_),
      socket_put(Sockfd1, CH_EOF_C,_), 
      socket_close(Sockfd0, _),
      socket_close(Sockfd1, _),
      writeln('Exiting.'), true
  ;   integer(Char) ->
      Char1 is Char + 1,
      socket_put(Sockfd0, Char, Err),
      writeln(socket_put(Sockfd0, Char, Err)),
      socket_put(Sockfd1, Char1, Err1),
      writeln(socket_put(Sockfd1, Char1, Err1)),	
      fail
  ;   write('Illegal input: '), writeln(Char),
      fail
  ).

client_loop(Sockfd0, Sockfd1) :- client_loop(Sockfd0, Sockfd1).


%% Open socket and connect
try_connect(Sockfd0,XSB_port,IPAddrOrHostname,Ecode) :-
	 socket(Sockfd0, ErrCode1),
	 (ErrCode1 =\= SOCK_OK
	 -> writeln('Cannot connect to the server.'), fail
	 ; true),
	 socket_set_option(Sockfd0,linger,SOCK_NOLINGER),
	 socket_connect(Sockfd0, XSB_port, IPAddrOrHostname, Ecode).

