/* Hidden Markov Model dataset: 500 sequences of an HMM with 2 states
and 2 output symbol.
Used in
Fabrizio Riguzzi and Nicola Di Mauro. Applying the information bottleneck
to statistical relational learning. Machine Learning, 86(1):89-114, 2012.

The program is from
Sato T, Kameya Y, Zhou NF (2005) Generative modeling with failure in prism.
In: Kaelbling LP, Saffiotti A (eds) Proceedings of the 19th International
Joint Conference on Artificial Intelligence, Professional Book Center,
pp 847-852

Examples generated randomly from the target program. The task is to recover
the values of the parameters of the target program (indicated in the input
program). When learning, the initial parameters are randomly set.
*/

/** <examples>
?- induce_par([train],P).  % learn the parameteters
*/
:- use_module(library(slipcover)).
:- use_module(library(lists)).

:- if(current_predicate(use_rendering/1)).
:- use_rendering(c3).
:- use_rendering(lpad).
:- endif.
:- import   between/3 from basics.

:-sc.


:-set_sc(beamsize,15).
:-set_sc(single_var,false).
:-set_sc(neg_ex,cw).
:-set_sc(depth_bound,false).
:-set_sc(verbosity,1).


bg([]).



output(success/1).

input(hmmf/3).
input(tr/2).

in([
(success(L) :- hmmf(L,[r0],3)),

(hmmf([p|L],S,N):0.1 ; hmmf([s|L],S,N):0.9 :- N>0,
	S=[r0|_],
	tr(S,R2),
	 N2 is N-1,
	hmmf(L,[R2|S],N2)),

(hmmf([s|L],S,N):0.1 ; hmmf([h|L],S,N):0.9 :- N>0,
	S=[r1|_],
	tr(S,R2),
	N2 is N-1,
	hmmf(L,[R2|S],N2)),

(hmmf([],S,0)),

(tr([r0|T],r0): 0.1 ; tr([r0|T],r1) : 0.9),
(tr([r1|T],r0): 0.1 ; tr([r1|T],r1) : 0.9)
]).


fold(train,L):-
  findall(V,between(1,500,V),L).


begin(model(1)).
success([s,h,h]).
end_mod(model(1)).
begin(model(2)).
success([s,p,p]).
end_mod(model(2)).
begin(model(3)).
success([s,s,s]).
end_mod(model(3)).
begin(model(4)).
success([s,s,s]).
end_mod(model(4)).
begin(model(5)).
success([s,s,h]).
end_mod(model(5)).
begin(model(6)).
success([p,p,s]).
end_mod(model(6)).
begin(model(7)).
success([p,p,s]).
end_mod(model(7)).
begin(model(8)).
success([s,s,p]).
end_mod(model(8)).
begin(model(9)).
success([s,p,p]).
end_mod(model(9)).
begin(model(10)).
success([p,p,h]).
end_mod(model(10)).
begin(model(11)).
success([s,h,h]).
end_mod(model(11)).
begin(model(12)).
success([p,p,s]).
end_mod(model(12)).
begin(model(13)).
success([s,s,s]).
end_mod(model(13)).
begin(model(14)).
success([s,s,p]).
end_mod(model(14)).
begin(model(15)).
success([s,s,s]).
end_mod(model(15)).
begin(model(16)).
success([p,s,s]).
end_mod(model(16)).
begin(model(17)).
success([p,p,h]).
end_mod(model(17)).
begin(model(18)).
success([p,p,s]).
end_mod(model(18)).
begin(model(19)).
success([s,p,h]).
end_mod(model(19)).
begin(model(20)).
success([p,s,s]).
end_mod(model(20)).
begin(model(21)).
success([s,h,h]).
end_mod(model(21)).
begin(model(22)).
success([p,s,s]).
end_mod(model(22)).
begin(model(23)).
success([p,s,p]).
end_mod(model(23)).
begin(model(24)).
success([p,s,s]).
end_mod(model(24)).
begin(model(25)).
success([s,p,p]).
end_mod(model(25)).
begin(model(26)).
success([s,s,s]).
end_mod(model(26)).
begin(model(27)).
success([s,s,p]).
end_mod(model(27)).
begin(model(28)).
success([p,s,p]).
end_mod(model(28)).
begin(model(29)).
success([s,p,s]).
end_mod(model(29)).
begin(model(30)).
success([s,h,s]).
end_mod(model(30)).
begin(model(31)).
success([s,h,h]).
end_mod(model(31)).
begin(model(32)).
success([s,p,s]).
end_mod(model(32)).
begin(model(33)).
success([s,h,h]).
end_mod(model(33)).
begin(model(34)).
success([s,p,s]).
end_mod(model(34)).
begin(model(35)).
success([p,s,s]).
end_mod(model(35)).
begin(model(36)).
success([p,s,p]).
end_mod(model(36)).
begin(model(37)).
success([s,p,p]).
end_mod(model(37)).
begin(model(38)).
success([s,h,s]).
end_mod(model(38)).
begin(model(39)).
success([s,p,p]).
end_mod(model(39)).
begin(model(40)).
success([s,s,h]).
end_mod(model(40)).
begin(model(41)).
success([p,p,p]).
end_mod(model(41)).
begin(model(42)).
success([s,s,p]).
end_mod(model(42)).
begin(model(43)).
success([s,s,s]).
end_mod(model(43)).
begin(model(44)).
success([p,p,s]).
end_mod(model(44)).
begin(model(45)).
success([s,s,h]).
end_mod(model(45)).
begin(model(46)).
success([s,s,s]).
end_mod(model(46)).
begin(model(47)).
success([s,p,s]).
end_mod(model(47)).
begin(model(48)).
success([s,s,h]).
end_mod(model(48)).
begin(model(49)).
success([s,p,s]).
end_mod(model(49)).
begin(model(50)).
success([p,s,p]).
end_mod(model(50)).
begin(model(51)).
success([s,s,s]).
end_mod(model(51)).
begin(model(52)).
success([s,s,s]).
end_mod(model(52)).
begin(model(53)).
success([p,s,s]).
end_mod(model(53)).
begin(model(54)).
success([s,h,s]).
end_mod(model(54)).
begin(model(55)).
success([s,s,s]).
end_mod(model(55)).
begin(model(56)).
success([s,s,s]).
end_mod(model(56)).
begin(model(57)).
success([p,h,h]).
end_mod(model(57)).
begin(model(58)).
success([s,s,s]).
end_mod(model(58)).
begin(model(59)).
success([s,s,s]).
end_mod(model(59)).
begin(model(60)).
success([s,p,s]).
end_mod(model(60)).
begin(model(61)).
success([s,p,s]).
end_mod(model(61)).
begin(model(62)).
success([p,s,s]).
end_mod(model(62)).
begin(model(63)).
success([p,s,s]).
end_mod(model(63)).
begin(model(64)).
success([p,s,p]).
end_mod(model(64)).
begin(model(65)).
success([s,s,s]).
end_mod(model(65)).
begin(model(66)).
success([s,s,h]).
end_mod(model(66)).
begin(model(67)).
success([p,s,p]).
end_mod(model(67)).
begin(model(68)).
success([p,h,p]).
end_mod(model(68)).
begin(model(69)).
success([p,p,s]).
end_mod(model(69)).
begin(model(70)).
success([s,s,h]).
end_mod(model(70)).
begin(model(71)).
success([s,s,h]).
end_mod(model(71)).
begin(model(72)).
success([p,s,p]).
end_mod(model(72)).
begin(model(73)).
success([p,p,s]).
end_mod(model(73)).
begin(model(74)).
success([s,p,s]).
end_mod(model(74)).
begin(model(75)).
success([p,s,h]).
end_mod(model(75)).
begin(model(76)).
success([s,s,s]).
end_mod(model(76)).
begin(model(77)).
success([p,p,s]).
end_mod(model(77)).
begin(model(78)).
success([s,h,h]).
end_mod(model(78)).
begin(model(79)).
success([p,s,h]).
end_mod(model(79)).
begin(model(80)).
success([p,s,s]).
end_mod(model(80)).
begin(model(81)).
success([p,p,p]).
end_mod(model(81)).
begin(model(82)).
success([s,s,s]).
end_mod(model(82)).
begin(model(83)).
success([s,s,s]).
end_mod(model(83)).
begin(model(84)).
success([p,p,s]).
end_mod(model(84)).
begin(model(85)).
success([s,h,s]).
end_mod(model(85)).
begin(model(86)).
success([p,s,p]).
end_mod(model(86)).
begin(model(87)).
success([p,p,s]).
end_mod(model(87)).
begin(model(88)).
success([p,s,s]).
end_mod(model(88)).
begin(model(89)).
success([p,s,h]).
end_mod(model(89)).
begin(model(90)).
success([s,s,s]).
end_mod(model(90)).
begin(model(91)).
success([p,s,s]).
end_mod(model(91)).
begin(model(92)).
success([s,s,s]).
end_mod(model(92)).
begin(model(93)).
success([s,s,p]).
end_mod(model(93)).
begin(model(94)).
success([s,s,p]).
end_mod(model(94)).
begin(model(95)).
success([p,h,s]).
end_mod(model(95)).
begin(model(96)).
success([p,s,s]).
end_mod(model(96)).
begin(model(97)).
success([s,s,s]).
end_mod(model(97)).
begin(model(98)).
success([s,s,s]).
end_mod(model(98)).
begin(model(99)).
success([p,s,s]).
end_mod(model(99)).
begin(model(100)).
success([p,s,h]).
end_mod(model(100)).
begin(model(101)).
success([s,s,s]).
end_mod(model(101)).
begin(model(102)).
success([s,s,s]).
end_mod(model(102)).
begin(model(103)).
success([p,s,s]).
end_mod(model(103)).
begin(model(104)).
success([p,s,s]).
end_mod(model(104)).
begin(model(105)).
success([p,p,p]).
end_mod(model(105)).
begin(model(106)).
success([p,s,h]).
end_mod(model(106)).
begin(model(107)).
success([p,s,p]).
end_mod(model(107)).
begin(model(108)).
success([s,p,s]).
end_mod(model(108)).
begin(model(109)).
success([p,s,h]).
end_mod(model(109)).
begin(model(110)).
success([s,h,s]).
end_mod(model(110)).
begin(model(111)).
success([p,p,p]).
end_mod(model(111)).
begin(model(112)).
success([s,s,h]).
end_mod(model(112)).
begin(model(113)).
success([s,p,p]).
end_mod(model(113)).
begin(model(114)).
success([s,s,p]).
end_mod(model(114)).
begin(model(115)).
success([s,h,h]).
end_mod(model(115)).
begin(model(116)).
success([p,s,h]).
end_mod(model(116)).
begin(model(117)).
success([s,s,h]).
end_mod(model(117)).
begin(model(118)).
success([p,s,s]).
end_mod(model(118)).
begin(model(119)).
success([s,h,h]).
end_mod(model(119)).
begin(model(120)).
success([p,s,s]).
end_mod(model(120)).
begin(model(121)).
success([s,s,s]).
end_mod(model(121)).
begin(model(122)).
success([s,s,p]).
end_mod(model(122)).
begin(model(123)).
success([p,s,s]).
end_mod(model(123)).
begin(model(124)).
success([p,s,p]).
end_mod(model(124)).
begin(model(125)).
success([s,s,p]).
end_mod(model(125)).
begin(model(126)).
success([p,s,h]).
end_mod(model(126)).
begin(model(127)).
success([s,s,s]).
end_mod(model(127)).
begin(model(128)).
success([p,s,s]).
end_mod(model(128)).
begin(model(129)).
success([p,h,h]).
end_mod(model(129)).
begin(model(130)).
success([p,s,p]).
end_mod(model(130)).
begin(model(131)).
success([p,s,s]).
end_mod(model(131)).
begin(model(132)).
success([p,s,s]).
end_mod(model(132)).
begin(model(133)).
success([s,s,p]).
end_mod(model(133)).
begin(model(134)).
success([p,s,h]).
end_mod(model(134)).
begin(model(135)).
success([p,s,p]).
end_mod(model(135)).
begin(model(136)).
success([s,s,s]).
end_mod(model(136)).
begin(model(137)).
success([p,h,h]).
end_mod(model(137)).
begin(model(138)).
success([s,s,h]).
end_mod(model(138)).
begin(model(139)).
success([s,s,s]).
end_mod(model(139)).
begin(model(140)).
success([p,s,h]).
end_mod(model(140)).
begin(model(141)).
success([p,s,s]).
end_mod(model(141)).
begin(model(142)).
success([s,s,p]).
end_mod(model(142)).
begin(model(143)).
success([p,p,s]).
end_mod(model(143)).
begin(model(144)).
success([p,s,s]).
end_mod(model(144)).
begin(model(145)).
success([s,s,s]).
end_mod(model(145)).
begin(model(146)).
success([s,s,p]).
end_mod(model(146)).
begin(model(147)).
success([s,s,s]).
end_mod(model(147)).
begin(model(148)).
success([s,p,p]).
end_mod(model(148)).
begin(model(149)).
success([p,s,p]).
end_mod(model(149)).
begin(model(150)).
success([s,h,h]).
end_mod(model(150)).
begin(model(151)).
success([s,s,s]).
end_mod(model(151)).
begin(model(152)).
success([p,s,s]).
end_mod(model(152)).
begin(model(153)).
success([s,h,h]).
end_mod(model(153)).
begin(model(154)).
success([s,s,s]).
end_mod(model(154)).
begin(model(155)).
success([s,p,s]).
end_mod(model(155)).
begin(model(156)).
success([s,h,h]).
end_mod(model(156)).
begin(model(157)).
success([p,h,p]).
end_mod(model(157)).
begin(model(158)).
success([p,p,s]).
end_mod(model(158)).
begin(model(159)).
success([p,p,s]).
end_mod(model(159)).
begin(model(160)).
success([s,p,s]).
end_mod(model(160)).
begin(model(161)).
success([s,p,s]).
end_mod(model(161)).
begin(model(162)).
success([s,s,s]).
end_mod(model(162)).
begin(model(163)).
success([s,s,p]).
end_mod(model(163)).
begin(model(164)).
success([p,h,h]).
end_mod(model(164)).
begin(model(165)).
success([s,p,s]).
end_mod(model(165)).
begin(model(166)).
success([s,s,s]).
end_mod(model(166)).
begin(model(167)).
success([s,s,s]).
end_mod(model(167)).
begin(model(168)).
success([s,s,s]).
end_mod(model(168)).
begin(model(169)).
success([s,s,s]).
end_mod(model(169)).
begin(model(170)).
success([s,h,s]).
end_mod(model(170)).
begin(model(171)).
success([s,s,s]).
end_mod(model(171)).
begin(model(172)).
success([s,s,p]).
end_mod(model(172)).
begin(model(173)).
success([p,p,s]).
end_mod(model(173)).
begin(model(174)).
success([s,s,s]).
end_mod(model(174)).
begin(model(175)).
success([s,s,s]).
end_mod(model(175)).
begin(model(176)).
success([s,p,s]).
end_mod(model(176)).
begin(model(177)).
success([s,p,s]).
end_mod(model(177)).
begin(model(178)).
success([s,p,s]).
end_mod(model(178)).
begin(model(179)).
success([s,s,h]).
end_mod(model(179)).
begin(model(180)).
success([p,p,s]).
end_mod(model(180)).
begin(model(181)).
success([p,s,s]).
end_mod(model(181)).
begin(model(182)).
success([p,p,s]).
end_mod(model(182)).
begin(model(183)).
success([p,s,s]).
end_mod(model(183)).
begin(model(184)).
success([s,p,h]).
end_mod(model(184)).
begin(model(185)).
success([s,s,p]).
end_mod(model(185)).
begin(model(186)).
success([s,s,h]).
end_mod(model(186)).
begin(model(187)).
success([p,p,s]).
end_mod(model(187)).
begin(model(188)).
success([s,p,s]).
end_mod(model(188)).
begin(model(189)).
success([s,s,s]).
end_mod(model(189)).
begin(model(190)).
success([s,p,s]).
end_mod(model(190)).
begin(model(191)).
success([s,s,s]).
end_mod(model(191)).
begin(model(192)).
success([p,s,s]).
end_mod(model(192)).
begin(model(193)).
success([s,s,p]).
end_mod(model(193)).
begin(model(194)).
success([p,p,h]).
end_mod(model(194)).
begin(model(195)).
success([p,s,s]).
end_mod(model(195)).
begin(model(196)).
success([p,p,p]).
end_mod(model(196)).
begin(model(197)).
success([p,s,s]).
end_mod(model(197)).
begin(model(198)).
success([s,p,s]).
end_mod(model(198)).
begin(model(199)).
success([p,s,s]).
end_mod(model(199)).
begin(model(200)).
success([p,h,s]).
end_mod(model(200)).
begin(model(201)).
success([p,p,p]).
end_mod(model(201)).
begin(model(202)).
success([s,h,s]).
end_mod(model(202)).
begin(model(203)).
success([s,s,h]).
end_mod(model(203)).
begin(model(204)).
success([s,s,s]).
end_mod(model(204)).
begin(model(205)).
success([s,h,h]).
end_mod(model(205)).
begin(model(206)).
success([s,p,p]).
end_mod(model(206)).
begin(model(207)).
success([s,s,s]).
end_mod(model(207)).
begin(model(208)).
success([s,s,s]).
end_mod(model(208)).
begin(model(209)).
success([s,s,h]).
end_mod(model(209)).
begin(model(210)).
success([s,s,p]).
end_mod(model(210)).
begin(model(211)).
success([p,s,s]).
end_mod(model(211)).
begin(model(212)).
success([p,h,s]).
end_mod(model(212)).
begin(model(213)).
success([s,s,s]).
end_mod(model(213)).
begin(model(214)).
success([s,h,s]).
end_mod(model(214)).
begin(model(215)).
success([s,h,h]).
end_mod(model(215)).
begin(model(216)).
success([s,p,p]).
end_mod(model(216)).
begin(model(217)).
success([s,h,s]).
end_mod(model(217)).
begin(model(218)).
success([s,s,s]).
end_mod(model(218)).
begin(model(219)).
success([s,p,p]).
end_mod(model(219)).
begin(model(220)).
success([s,s,s]).
end_mod(model(220)).
begin(model(221)).
success([p,s,s]).
end_mod(model(221)).
begin(model(222)).
success([p,s,s]).
end_mod(model(222)).
begin(model(223)).
success([s,s,h]).
end_mod(model(223)).
begin(model(224)).
success([s,s,s]).
end_mod(model(224)).
begin(model(225)).
success([s,s,p]).
end_mod(model(225)).
begin(model(226)).
success([s,h,p]).
end_mod(model(226)).
begin(model(227)).
success([p,p,s]).
end_mod(model(227)).
begin(model(228)).
success([s,s,h]).
end_mod(model(228)).
begin(model(229)).
success([s,s,s]).
end_mod(model(229)).
begin(model(230)).
success([s,s,s]).
end_mod(model(230)).
begin(model(231)).
success([s,s,s]).
end_mod(model(231)).
begin(model(232)).
success([s,s,s]).
end_mod(model(232)).
begin(model(233)).
success([s,h,h]).
end_mod(model(233)).
begin(model(234)).
success([p,s,h]).
end_mod(model(234)).
begin(model(235)).
success([s,s,p]).
end_mod(model(235)).
begin(model(236)).
success([s,s,s]).
end_mod(model(236)).
begin(model(237)).
success([s,p,h]).
end_mod(model(237)).
begin(model(238)).
success([p,p,h]).
end_mod(model(238)).
begin(model(239)).
success([s,s,s]).
end_mod(model(239)).
begin(model(240)).
success([p,h,s]).
end_mod(model(240)).
begin(model(241)).
success([p,s,s]).
end_mod(model(241)).
begin(model(242)).
success([s,p,s]).
end_mod(model(242)).
begin(model(243)).
success([p,p,p]).
end_mod(model(243)).
begin(model(244)).
success([s,p,h]).
end_mod(model(244)).
begin(model(245)).
success([s,s,s]).
end_mod(model(245)).
begin(model(246)).
success([p,s,s]).
end_mod(model(246)).
begin(model(247)).
success([s,s,p]).
end_mod(model(247)).
begin(model(248)).
success([p,p,s]).
end_mod(model(248)).
begin(model(249)).
success([s,s,h]).
end_mod(model(249)).
begin(model(250)).
success([s,p,s]).
end_mod(model(250)).
begin(model(251)).
success([s,s,h]).
end_mod(model(251)).
begin(model(252)).
success([p,h,s]).
end_mod(model(252)).
begin(model(253)).
success([s,s,p]).
end_mod(model(253)).
begin(model(254)).
success([s,s,h]).
end_mod(model(254)).
begin(model(255)).
success([s,s,s]).
end_mod(model(255)).
begin(model(256)).
success([s,s,s]).
end_mod(model(256)).
begin(model(257)).
success([s,p,h]).
end_mod(model(257)).
begin(model(258)).
success([s,s,s]).
end_mod(model(258)).
begin(model(259)).
success([s,s,s]).
end_mod(model(259)).
begin(model(260)).
success([p,h,p]).
end_mod(model(260)).
begin(model(261)).
success([p,s,s]).
end_mod(model(261)).
begin(model(262)).
success([s,s,s]).
end_mod(model(262)).
begin(model(263)).
success([s,p,s]).
end_mod(model(263)).
begin(model(264)).
success([p,p,s]).
end_mod(model(264)).
begin(model(265)).
success([p,h,s]).
end_mod(model(265)).
begin(model(266)).
success([p,p,s]).
end_mod(model(266)).
begin(model(267)).
success([p,s,s]).
end_mod(model(267)).
begin(model(268)).
success([p,s,p]).
end_mod(model(268)).
begin(model(269)).
success([s,s,s]).
end_mod(model(269)).
begin(model(270)).
success([p,s,p]).
end_mod(model(270)).
begin(model(271)).
success([p,s,s]).
end_mod(model(271)).
begin(model(272)).
success([s,s,s]).
end_mod(model(272)).
begin(model(273)).
success([s,s,s]).
end_mod(model(273)).
begin(model(274)).
success([p,p,s]).
end_mod(model(274)).
begin(model(275)).
success([s,s,s]).
end_mod(model(275)).
begin(model(276)).
success([s,p,s]).
end_mod(model(276)).
begin(model(277)).
success([p,s,h]).
end_mod(model(277)).
begin(model(278)).
success([s,s,p]).
end_mod(model(278)).
begin(model(279)).
success([s,p,p]).
end_mod(model(279)).
begin(model(280)).
success([s,s,s]).
end_mod(model(280)).
begin(model(281)).
success([s,s,s]).
end_mod(model(281)).
begin(model(282)).
success([p,s,h]).
end_mod(model(282)).
begin(model(283)).
success([s,s,h]).
end_mod(model(283)).
begin(model(284)).
success([s,s,s]).
end_mod(model(284)).
begin(model(285)).
success([p,p,h]).
end_mod(model(285)).
begin(model(286)).
success([s,s,s]).
end_mod(model(286)).
begin(model(287)).
success([s,h,h]).
end_mod(model(287)).
begin(model(288)).
success([s,s,h]).
end_mod(model(288)).
begin(model(289)).
success([s,h,h]).
end_mod(model(289)).
begin(model(290)).
success([s,s,s]).
end_mod(model(290)).
begin(model(291)).
success([s,p,h]).
end_mod(model(291)).
begin(model(292)).
success([p,p,p]).
end_mod(model(292)).
begin(model(293)).
success([s,s,p]).
end_mod(model(293)).
begin(model(294)).
success([s,p,s]).
end_mod(model(294)).
begin(model(295)).
success([p,p,h]).
end_mod(model(295)).
begin(model(296)).
success([s,s,h]).
end_mod(model(296)).
begin(model(297)).
success([s,p,p]).
end_mod(model(297)).
begin(model(298)).
success([p,s,h]).
end_mod(model(298)).
begin(model(299)).
success([p,s,s]).
end_mod(model(299)).
begin(model(300)).
success([p,s,s]).
end_mod(model(300)).
begin(model(301)).
success([p,p,s]).
end_mod(model(301)).
begin(model(302)).
success([p,p,s]).
end_mod(model(302)).
begin(model(303)).
success([s,s,s]).
end_mod(model(303)).
begin(model(304)).
success([s,s,s]).
end_mod(model(304)).
begin(model(305)).
success([s,p,s]).
end_mod(model(305)).
begin(model(306)).
success([p,s,h]).
end_mod(model(306)).
begin(model(307)).
success([s,h,s]).
end_mod(model(307)).
begin(model(308)).
success([p,p,p]).
end_mod(model(308)).
begin(model(309)).
success([s,p,s]).
end_mod(model(309)).
begin(model(310)).
success([s,s,h]).
end_mod(model(310)).
begin(model(311)).
success([p,h,p]).
end_mod(model(311)).
begin(model(312)).
success([s,p,s]).
end_mod(model(312)).
begin(model(313)).
success([p,p,p]).
end_mod(model(313)).
begin(model(314)).
success([p,s,p]).
end_mod(model(314)).
begin(model(315)).
success([s,p,s]).
end_mod(model(315)).
begin(model(316)).
success([p,h,s]).
end_mod(model(316)).
begin(model(317)).
success([s,s,s]).
end_mod(model(317)).
begin(model(318)).
success([p,p,h]).
end_mod(model(318)).
begin(model(319)).
success([s,p,s]).
end_mod(model(319)).
begin(model(320)).
success([s,s,s]).
end_mod(model(320)).
begin(model(321)).
success([s,p,h]).
end_mod(model(321)).
begin(model(322)).
success([s,h,h]).
end_mod(model(322)).
begin(model(323)).
success([p,p,h]).
end_mod(model(323)).
begin(model(324)).
success([s,p,p]).
end_mod(model(324)).
begin(model(325)).
success([s,p,p]).
end_mod(model(325)).
begin(model(326)).
success([s,s,h]).
end_mod(model(326)).
begin(model(327)).
success([s,s,p]).
end_mod(model(327)).
begin(model(328)).
success([s,s,s]).
end_mod(model(328)).
begin(model(329)).
success([s,s,s]).
end_mod(model(329)).
begin(model(330)).
success([s,p,h]).
end_mod(model(330)).
begin(model(331)).
success([s,h,s]).
end_mod(model(331)).
begin(model(332)).
success([s,s,h]).
end_mod(model(332)).
begin(model(333)).
success([p,h,h]).
end_mod(model(333)).
begin(model(334)).
success([p,p,p]).
end_mod(model(334)).
begin(model(335)).
success([p,s,h]).
end_mod(model(335)).
begin(model(336)).
success([s,s,h]).
end_mod(model(336)).
begin(model(337)).
success([s,p,s]).
end_mod(model(337)).
begin(model(338)).
success([p,p,p]).
end_mod(model(338)).
begin(model(339)).
success([p,s,h]).
end_mod(model(339)).
begin(model(340)).
success([p,p,s]).
end_mod(model(340)).
begin(model(341)).
success([p,p,p]).
end_mod(model(341)).
begin(model(342)).
success([p,p,s]).
end_mod(model(342)).
begin(model(343)).
success([p,s,p]).
end_mod(model(343)).
begin(model(344)).
success([s,s,s]).
end_mod(model(344)).
begin(model(345)).
success([p,h,p]).
end_mod(model(345)).
begin(model(346)).
success([p,s,p]).
end_mod(model(346)).
begin(model(347)).
success([s,h,s]).
end_mod(model(347)).
begin(model(348)).
success([s,p,s]).
end_mod(model(348)).
begin(model(349)).
success([p,s,h]).
end_mod(model(349)).
begin(model(350)).
success([s,s,s]).
end_mod(model(350)).
begin(model(351)).
success([s,s,p]).
end_mod(model(351)).
begin(model(352)).
success([s,s,p]).
end_mod(model(352)).
begin(model(353)).
success([s,s,h]).
end_mod(model(353)).
begin(model(354)).
success([s,s,s]).
end_mod(model(354)).
begin(model(355)).
success([s,s,h]).
end_mod(model(355)).
begin(model(356)).
success([s,s,h]).
end_mod(model(356)).
begin(model(357)).
success([p,p,s]).
end_mod(model(357)).
begin(model(358)).
success([p,h,s]).
end_mod(model(358)).
begin(model(359)).
success([p,s,s]).
end_mod(model(359)).
begin(model(360)).
success([s,p,p]).
end_mod(model(360)).
begin(model(361)).
success([p,p,p]).
end_mod(model(361)).
begin(model(362)).
success([p,h,p]).
end_mod(model(362)).
begin(model(363)).
success([p,s,s]).
end_mod(model(363)).
begin(model(364)).
success([p,s,s]).
end_mod(model(364)).
begin(model(365)).
success([s,s,s]).
end_mod(model(365)).
begin(model(366)).
success([s,p,h]).
end_mod(model(366)).
begin(model(367)).
success([s,h,p]).
end_mod(model(367)).
begin(model(368)).
success([s,s,h]).
end_mod(model(368)).
begin(model(369)).
success([s,h,h]).
end_mod(model(369)).
begin(model(370)).
success([s,p,s]).
end_mod(model(370)).
begin(model(371)).
success([s,p,s]).
end_mod(model(371)).
begin(model(372)).
success([s,s,h]).
end_mod(model(372)).
begin(model(373)).
success([p,h,s]).
end_mod(model(373)).
begin(model(374)).
success([s,p,p]).
end_mod(model(374)).
begin(model(375)).
success([s,h,s]).
end_mod(model(375)).
begin(model(376)).
success([p,s,s]).
end_mod(model(376)).
begin(model(377)).
success([s,s,s]).
end_mod(model(377)).
begin(model(378)).
success([s,s,h]).
end_mod(model(378)).
begin(model(379)).
success([s,s,p]).
end_mod(model(379)).
begin(model(380)).
success([s,p,p]).
end_mod(model(380)).
begin(model(381)).
success([p,p,s]).
end_mod(model(381)).
begin(model(382)).
success([s,s,s]).
end_mod(model(382)).
begin(model(383)).
success([s,s,s]).
end_mod(model(383)).
begin(model(384)).
success([s,p,s]).
end_mod(model(384)).
begin(model(385)).
success([s,s,s]).
end_mod(model(385)).
begin(model(386)).
success([s,s,s]).
end_mod(model(386)).
begin(model(387)).
success([p,s,s]).
end_mod(model(387)).
begin(model(388)).
success([s,s,s]).
end_mod(model(388)).
begin(model(389)).
success([s,h,s]).
end_mod(model(389)).
begin(model(390)).
success([p,h,h]).
end_mod(model(390)).
begin(model(391)).
success([p,s,s]).
end_mod(model(391)).
begin(model(392)).
success([p,s,s]).
end_mod(model(392)).
begin(model(393)).
success([p,s,p]).
end_mod(model(393)).
begin(model(394)).
success([s,h,s]).
end_mod(model(394)).
begin(model(395)).
success([p,h,s]).
end_mod(model(395)).
begin(model(396)).
success([p,s,p]).
end_mod(model(396)).
begin(model(397)).
success([p,p,s]).
end_mod(model(397)).
begin(model(398)).
success([p,h,s]).
end_mod(model(398)).
begin(model(399)).
success([p,h,p]).
end_mod(model(399)).
begin(model(400)).
success([p,p,h]).
end_mod(model(400)).
begin(model(401)).
success([s,s,p]).
end_mod(model(401)).
begin(model(402)).
success([s,s,h]).
end_mod(model(402)).
begin(model(403)).
success([s,s,p]).
end_mod(model(403)).
begin(model(404)).
success([s,p,s]).
end_mod(model(404)).
begin(model(405)).
success([p,s,s]).
end_mod(model(405)).
begin(model(406)).
success([s,s,s]).
end_mod(model(406)).
begin(model(407)).
success([s,s,s]).
end_mod(model(407)).
begin(model(408)).
success([s,s,s]).
end_mod(model(408)).
begin(model(409)).
success([p,s,p]).
end_mod(model(409)).
begin(model(410)).
success([p,h,s]).
end_mod(model(410)).
begin(model(411)).
success([s,s,s]).
end_mod(model(411)).
begin(model(412)).
success([s,s,s]).
end_mod(model(412)).
begin(model(413)).
success([s,s,s]).
end_mod(model(413)).
begin(model(414)).
success([s,p,h]).
end_mod(model(414)).
begin(model(415)).
success([s,s,s]).
end_mod(model(415)).
begin(model(416)).
success([s,s,p]).
end_mod(model(416)).
begin(model(417)).
success([s,p,h]).
end_mod(model(417)).
begin(model(418)).
success([s,h,h]).
end_mod(model(418)).
begin(model(419)).
success([s,s,h]).
end_mod(model(419)).
begin(model(420)).
success([s,s,p]).
end_mod(model(420)).
begin(model(421)).
success([s,p,p]).
end_mod(model(421)).
begin(model(422)).
success([p,p,s]).
end_mod(model(422)).
begin(model(423)).
success([s,h,h]).
end_mod(model(423)).
begin(model(424)).
success([s,s,s]).
end_mod(model(424)).
begin(model(425)).
success([s,s,h]).
end_mod(model(425)).
begin(model(426)).
success([s,h,s]).
end_mod(model(426)).
begin(model(427)).
success([p,p,s]).
end_mod(model(427)).
begin(model(428)).
success([s,s,s]).
end_mod(model(428)).
begin(model(429)).
success([p,s,s]).
end_mod(model(429)).
begin(model(430)).
success([s,s,p]).
end_mod(model(430)).
begin(model(431)).
success([s,p,s]).
end_mod(model(431)).
begin(model(432)).
success([s,s,s]).
end_mod(model(432)).
begin(model(433)).
success([s,s,s]).
end_mod(model(433)).
begin(model(434)).
success([p,p,p]).
end_mod(model(434)).
begin(model(435)).
success([s,s,s]).
end_mod(model(435)).
begin(model(436)).
success([s,s,s]).
end_mod(model(436)).
begin(model(437)).
success([p,s,s]).
end_mod(model(437)).
begin(model(438)).
success([p,s,s]).
end_mod(model(438)).
begin(model(439)).
success([s,h,s]).
end_mod(model(439)).
begin(model(440)).
success([p,h,h]).
end_mod(model(440)).
begin(model(441)).
success([p,p,s]).
end_mod(model(441)).
begin(model(442)).
success([s,s,s]).
end_mod(model(442)).
begin(model(443)).
success([p,p,p]).
end_mod(model(443)).
begin(model(444)).
success([s,p,s]).
end_mod(model(444)).
begin(model(445)).
success([s,s,s]).
end_mod(model(445)).
begin(model(446)).
success([s,s,s]).
end_mod(model(446)).
begin(model(447)).
success([s,s,p]).
end_mod(model(447)).
begin(model(448)).
success([s,p,s]).
end_mod(model(448)).
begin(model(449)).
success([s,s,s]).
end_mod(model(449)).
begin(model(450)).
success([s,s,h]).
end_mod(model(450)).
begin(model(451)).
success([p,s,s]).
end_mod(model(451)).
begin(model(452)).
success([p,h,s]).
end_mod(model(452)).
begin(model(453)).
success([p,p,h]).
end_mod(model(453)).
begin(model(454)).
success([s,s,p]).
end_mod(model(454)).
begin(model(455)).
success([p,s,s]).
end_mod(model(455)).
begin(model(456)).
success([s,p,h]).
end_mod(model(456)).
begin(model(457)).
success([p,s,p]).
end_mod(model(457)).
begin(model(458)).
success([p,s,p]).
end_mod(model(458)).
begin(model(459)).
success([p,s,h]).
end_mod(model(459)).
begin(model(460)).
success([s,s,s]).
end_mod(model(460)).
begin(model(461)).
success([s,p,s]).
end_mod(model(461)).
begin(model(462)).
success([s,s,p]).
end_mod(model(462)).
begin(model(463)).
success([s,h,h]).
end_mod(model(463)).
begin(model(464)).
success([p,h,p]).
end_mod(model(464)).
begin(model(465)).
success([p,s,s]).
end_mod(model(465)).
begin(model(466)).
success([p,s,p]).
end_mod(model(466)).
begin(model(467)).
success([p,p,s]).
end_mod(model(467)).
begin(model(468)).
success([p,s,s]).
end_mod(model(468)).
begin(model(469)).
success([s,s,s]).
end_mod(model(469)).
begin(model(470)).
success([p,s,s]).
end_mod(model(470)).
begin(model(471)).
success([s,s,s]).
end_mod(model(471)).
begin(model(472)).
success([p,s,s]).
end_mod(model(472)).
begin(model(473)).
success([p,s,p]).
end_mod(model(473)).
begin(model(474)).
success([s,s,s]).
end_mod(model(474)).
begin(model(475)).
success([p,s,s]).
end_mod(model(475)).
begin(model(476)).
success([p,p,s]).
end_mod(model(476)).
begin(model(477)).
success([p,h,s]).
end_mod(model(477)).
begin(model(478)).
success([p,s,h]).
end_mod(model(478)).
begin(model(479)).
success([s,p,s]).
end_mod(model(479)).
begin(model(480)).
success([p,s,s]).
end_mod(model(480)).
begin(model(481)).
success([s,p,h]).
end_mod(model(481)).
begin(model(482)).
success([s,p,s]).
end_mod(model(482)).
begin(model(483)).
success([p,s,h]).
end_mod(model(483)).
begin(model(484)).
success([s,s,p]).
end_mod(model(484)).
begin(model(485)).
success([s,h,s]).
end_mod(model(485)).
begin(model(486)).
success([s,s,p]).
end_mod(model(486)).
begin(model(487)).
success([s,p,p]).
end_mod(model(487)).
begin(model(488)).
success([s,s,s]).
end_mod(model(488)).
begin(model(489)).
success([s,s,s]).
end_mod(model(489)).
begin(model(490)).
success([s,s,p]).
end_mod(model(490)).
begin(model(491)).
success([p,p,s]).
end_mod(model(491)).
begin(model(492)).
success([p,h,h]).
end_mod(model(492)).
begin(model(493)).
success([p,s,h]).
end_mod(model(493)).
begin(model(494)).
success([p,h,s]).
end_mod(model(494)).
begin(model(495)).
success([s,p,s]).
end_mod(model(495)).
begin(model(496)).
success([s,s,s]).
end_mod(model(496)).
begin(model(497)).
success([s,p,s]).
end_mod(model(497)).
begin(model(498)).
success([p,s,p]).
end_mod(model(498)).
begin(model(499)).
success([s,p,p]).
end_mod(model(499)).
begin(model(500)).
success([s,s,s]).
end_mod(model(500)).
