/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.BuildResult;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.exception.DefaultExceptionAnalyser;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.exception.ExceptionCollector;
import org.gradle.initialization.exception.MultipleBuildFailuresExceptionAnalyser;
import org.gradle.initialization.exception.StackTraceSanitizingExceptionAnalyser;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildLoggerFactory;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;
import org.gradle.tooling.internal.provider.BuildSessionLifecycleBuildActionExecuter;

public class SessionFailureReportingActionExecuter
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate;
    private final BuildLoggerFactory buildLoggerFactory;

    public SessionFailureReportingActionExecuter(BuildLoggerFactory buildLoggerFactory, BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate) {
        this.delegate = delegate;
        this.buildLoggerFactory = buildLoggerFactory;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        try {
            return this.delegate.execute(action, actionParameters, requestContext);
        }
        catch (Throwable e) {
            MultipleBuildFailuresExceptionAnalyser exceptionAnalyser = new MultipleBuildFailuresExceptionAnalyser((ExceptionCollector)new DefaultExceptionAnalyser((ProblemDiagnosticsFactory)new NoOpProblemDiagnosticsFactory()));
            if (action.getStartParameter().getShowStacktrace() != ShowStacktrace.ALWAYS_FULL) {
                exceptionAnalyser = new StackTraceSanitizingExceptionAnalyser((ExceptionAnalyser)exceptionAnalyser);
            }
            RuntimeException failure = exceptionAnalyser.transform(e);
            BuildStartedTime buildStartedTime = BuildStartedTime.startingAt((long)requestContext.getStartTime());
            BuildLogger buildLogger = this.buildLoggerFactory.create(Logging.getLogger(BuildSessionLifecycleBuildActionExecuter.class), (LoggingConfiguration)action.getStartParameter(), buildStartedTime, (BuildRequestMetaData)requestContext);
            buildLogger.buildFinished(new BuildResult(null, (Throwable)failure));
            buildLogger.logResult((Throwable)failure);
            return BuildActionResult.failed(failure);
        }
    }
}

