/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;

@Incubating
@DisableCachingByDefault(because="Super-class, not to be instantiated directly")
public abstract class AbstractCodeQualityTask
extends SourceTask
implements VerificationTask {
    private static final String OPEN_MODULES_ARG = "java.prefs/java.util.prefs=ALL-UNNAMED";

    @Inject
    public AbstractCodeQualityTask() {
        this.getIgnoreFailuresProperty().convention((Object)false);
        this.getJavaLauncher().convention(this.getToolchainService().launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(this.getObjectFactory())));
    }

    public boolean getIgnoreFailures() {
        return (Boolean)this.getIgnoreFailuresProperty().get();
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.getIgnoreFailuresProperty().set((Object)ignoreFailures);
    }

    @Internal
    protected abstract Property<Boolean> getIgnoreFailuresProperty();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract JavaToolchainService getToolchainService();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    protected void configureForkOptions(JavaForkOptions forkOptions) {
        forkOptions.setMinHeapSize((String)this.getMinHeapSize().getOrNull());
        forkOptions.setMaxHeapSize((String)this.getMaxHeapSize().getOrNull());
        forkOptions.setExecutable(((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
        AbstractCodeQualityTask.maybeAddOpensJvmArgs((JavaLauncher)this.getJavaLauncher().get(), forkOptions);
    }

    private static void maybeAddOpensJvmArgs(JavaLauncher javaLauncher, JavaForkOptions forkOptions) {
        if (JavaVersion.toVersion((Object)javaLauncher.getMetadata().getJavaRuntimeVersion()).isJava9Compatible()) {
            forkOptions.jvmArgs(new Object[]{"--add-opens", OPEN_MODULES_ARG});
        }
    }

    @Nested
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Optional
    @Input
    public abstract Property<String> getMinHeapSize();

    @Optional
    @Input
    public abstract Property<String> getMaxHeapSize();
}

