/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public final class ReplayPrefixOneCharInputStream
extends InputStream {
    private byte firstByte;
    private int byteLength;
    private InputStream wrappedStream;
    private int byteRead;
    private final String encoding;

    public ReplayPrefixOneCharInputStream(String string) {
        assert (string != null);
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setInput(int n, InputStream inputStream) throws IOException {
        this.byteRead = 0;
        this.firstByte = (byte)n;
        this.wrappedStream = inputStream;
        this.byteLength = 1;
        if (this.encoding.equalsIgnoreCase("UTF-8")) {
            this.setInputUTF8(n, inputStream);
        } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
            this.byteLength = 2;
        } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
            this.byteLength = 4;
        }
    }

    public void setInputUTF8(int n, InputStream inputStream) throws IOException {
        if ((this.firstByte & 0xFFFFFFE0) == -64) {
            this.byteLength = 2;
        } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
            this.byteLength = 3;
        } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
            this.byteLength = 4;
        } else {
            throw new IOException(MessageFormat.format("Invalid UTF-8 first byte: {0}", this.firstByte));
        }
    }

    public int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        ++this.byteRead;
        if (this.byteRead == 1) {
            return this.firstByte;
        }
        return this.wrappedStream.read();
    }

    public int available() {
        return this.byteLength - this.byteRead;
    }
}

