/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.packages;

import java.io.File;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class PackageInspector
extends ProxyReceiver {
    private String packageName;
    private String packageVersion = "1";
    private int elementCount = 0;

    private PackageInspector(PipelineConfiguration pipe) {
        super(new Sink(pipe));
    }

    @Override
    public void startElement(NodeName namecode, SchemaType typecode, Location location, int properties) throws XPathException {
        if (this.elementCount++ >= 1) {
            throw new XPathException("#start#");
        }
    }

    @Override
    public void attribute(NodeName name, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (name.getLocalPart().equals("name")) {
            this.packageName = value.toString();
        } else if (name.getLocalPart().equals("package-version") || name.getLocalPart().equals("packageVersion")) {
            this.packageVersion = value.toString();
        }
    }

    private VersionedPackageName getNameAndVersion() {
        if (this.packageName == null) {
            return null;
        }
        try {
            return new VersionedPackageName(this.packageName, this.packageVersion);
        }
        catch (XPathException e) {
            return null;
        }
    }

    public static PackageDetails getPackageDetails(File top, Configuration config) {
        PackageInspector inspector = new PackageInspector(config.makePipelineConfiguration());
        try {
            Sender.send(new StreamSource(top), inspector, new ParseOptions());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        VersionedPackageName vp = inspector.getNameAndVersion();
        if (vp == null) {
            return null;
        }
        PackageDetails details = new PackageDetails();
        details.nameAndVersion = vp;
        details.sourceLocation = new StreamSource(top);
        return details;
    }
}

