#!/bin/awk -f

# This AWK script lists any of the following domains that do not resolve
# with a given version of Deadwood.  To run, have Deadwood on 127.0.0.1 set
# up to recursively resolve domains then (without the leading hashes):
#
# for a in $( grep '^a' alexa.awk | cut -f2 -d\" ) ; do askmara A${a} \
#	| grep -v '#'; done > foo
#
# This is followed by:
#
# awk -f alexa.awk < foo
#
# This will list all of the domains that did *not* resolve; a blank list is
# a good thing.
#
# The list of domains is based on an older "alexa 500" list with three
# now-unresolving domains removed.
#
# Deadwood is able to resolve all of the domains here on most days the
# second or third time this test is run starting with an empty cache.

BEGIN{
a["126.com."] = 1
a["163.com."] = 1
a["2ch.net."] = 1
a["39.net."] = 1
a["4shared.com."] = 1
a["56.com."] = 1
a["6.cn."] = 1
a["888.com."] = 1
a["about.com."] = 1
a["acer.com."] = 1
a["addictinggames.com."] = 1
a["adobe.com."] = 1
a["adsrevenue.net."] = 1
a["adultadworld.com."] = 1
a["adultfriendfinder.com."] = 1
a["advertserve.com."] = 1
a["alibaba.com."] = 1
a["alice.it."] = 1
a["alimama.com."] = 1
a["allegro.pl."] = 1
a["altervista.org."] = 1
a["amazon.co.jp."] = 1
a["amazon.com."] = 1
a["amazon.co.uk."] = 1
a["amazon.de."] = 1
a["ameba.jp."] = 1
a["ameblo.jp."] = 1
a["anonym.to."] = 1
a["answers.com."] = 1
a["aol.com."] = 1
a["apple.com."] = 1
a["archive.org."] = 1
a["ask.com."] = 1
a["atdmt.com."] = 1
a["att.com."] = 1
a["att.net."] = 1
a["atwiki.jp."] = 1
a["avast.com."] = 1
a["avg.com."] = 1
a["aweber.com."] = 1
a["awempire.com."] = 1
a["babylon.com."] = 1
a["badongo.com."] = 1
a["badoo.com."] = 1
a["baidu.com."] = 1
a["bangbros1.com."] = 1
a["bankofamerica.com."] = 1
a["bbc.co.uk."] = 1
a["bebo.com."] = 1
a["bestbuy.com."] = 1
a["bharatstudent.com."] = 1
a["biglobe.ne.jp."] = 1
a["bigpoint.com."] = 1
a["bild.de."] = 1
a["blogcatalog.com."] = 1
a["blogfa.com."] = 1
a["blogger.com."] = 1
a["bloomberg.com."] = 1
a["brazzers.com."] = 1
a["break.com."] = 1
a["cams.com."] = 1
a["careerbuilder.com."] = 1
a["cartoonnetwork.com."] = 1
a["cctv.com."] = 1
a["celldorado.com."] = 1
a["china.com."] = 1
a["chinaz.com."] = 1
a["chip.de."] = 1
a["clarin.com."] = 1
a["clicksor.com."] = 1
a["clicksor.net."] = 1
a["cnet.com."] = 1
a["cnn.com."] = 1
a["cnzz.com."] = 1
a["cocolog-nifty.com."] = 1
a["comcast.net."] = 1
a["commentcamarche.net."] = 1
a["conduit.com."] = 1
a["corriere.it."] = 1
a["craigslist.org."] = 1
a["cricinfo.com."] = 1
a["cyworld.com."] = 1
a["dailymail.co.uk."] = 1
a["dailymotion.com."] = 1
a["dantri.com.vn."] = 1
a["daqi.com."] = 1
a["daum.net."] = 1
a["debonairblog.com."] = 1
a["dell.com."] = 1
a["depositfiles.com."] = 1
a["desktopsmiley.com."] = 1
a["detik.com."] = 1
a["deviantart.com."] = 1
a["digg.com."] = 1
a["digitalpoint.com."] = 1
a["directaclick.com."] = 1
a["disney.go.com."] = 1
a["dmm.co.jp."] = 1
a["domaintools.com."] = 1
a["douban.com."] = 1
a["doubleclick.com."] = 1
a["download.com."] = 1
a["dtiblog.com."] = 1
a["duowan.com."] = 1
a["dyndns.org."] = 1
a["eastmoney.com."] = 1
a["easy-share.com."] = 1
a["ebay.com."] = 1
a["ebay.com.au."] = 1
a["ebay.co.uk."] = 1
a["ebay.de."] = 1
a["ebay.fr."] = 1
a["ebay.it."] = 1
a["ehow.com."] = 1
a["elmundo.es."] = 1
a["enet.com.cn."] = 1
a["eorezo.com."] = 1
a["espn.go.com."] = 1
a["exblog.jp."] = 1
a["excite.co.jp."] = 1
a["expedia.com."] = 1
a["ezinearticles.com."] = 1
a["facebook.com."] = 1
a["fanfiction.net."] = 1
a["fastclick.com."] = 1
a["fc2.com."] = 1
a["filefactory.com."] = 1
a["files.wordpress.com."] = 1
a["flickr.com."] = 1
a["fling.com."] = 1
a["forbes.com."] = 1
a["forumcommunity.net."] = 1
a["fotolog.net."] = 1
a["foxnews.com."] = 1
a["foxsports.com."] = 1
a["free.fr."] = 1
a["freelotto.com."] = 1
a["freeones.com."] = 1
a["friendster.com."] = 1
a["gamefaqs.com."] = 1
a["gamespot.com."] = 1
a["geocities.com."] = 1
a["geocities.jp."] = 1
a["globe7.com."] = 1
a["globo.com."] = 1
a["gmx.net."] = 1
a["go.com."] = 1
a["godaddy.com."] = 1
a["google.ae."] = 1
a["google.at."] = 1
a["google.be."] = 1
a["google.ca."] = 1
a["google.ch."] = 1
a["google.cl."] = 1
a["google.cn."] = 1
a["google.co.hu."] = 1
a["google.co.id."] = 1
a["google.co.il."] = 1
a["google.co.in."] = 1
a["google.co.jp."] = 1
a["google.co.kr."] = 1
a["google.com."] = 1
a["google.com.ar."] = 1
a["google.com.au."] = 1
a["google.com.bd."] = 1
a["google.com.br."] = 1
a["google.com.co."] = 1
a["google.com.eg."] = 1
a["google.com.mx."] = 1
a["google.com.my."] = 1
a["google.com.pe."] = 1
a["google.com.ph."] = 1
a["google.com.pk."] = 1
a["google.com.sa."] = 1
a["google.com.sg."] = 1
a["google.com.tr."] = 1
a["google.com.tw."] = 1
a["google.com.ua."] = 1
a["google.com.vn."] = 1
a["google.co.th."] = 1
a["google.co.uk."] = 1
a["google.co.ve."] = 1
a["google.co.za."] = 1
a["google.de."] = 1
a["google.dk."] = 1
a["google.dz."] = 1
a["google.es."] = 1
a["google.fi."] = 1
a["google.fr."] = 1
a["google.gr."] = 1
a["google.ie."] = 1
a["google.it."] = 1
a["google.nl."] = 1
a["google.no."] = 1
a["google.pl."] = 1
a["google.pt."] = 1
a["google.ro."] = 1
a["google.ru."] = 1
a["google.se."] = 1
a["goo.ne.jp."] = 1
a["gougou.com."] = 1
a["guardian.co.uk."] = 1
a["harrenmedianetwork.com."] = 1
a["hatena.ne.jp."] = 1
a["heise.de."] = 1
a["hi5.com."] = 1
a["homeway.com.cn."] = 1
a["hp.com."] = 1
a["hubpages.com."] = 1
a["huffingtonpost.com."] = 1
a["hulu.com."] = 1
a["hurriyet.com.tr."] = 1
a["hyves.nl."] = 1
a["ibm.com."] = 1
a["icq.com."] = 1
a["ifeng.com."] = 1
a["ig.com.br."] = 1
a["ign.com."] = 1
a["ikea.com."] = 1
a["imagebam.com."] = 1
a["imageshack.us."] = 1
a["imagevenue.com."] = 1
a["imdb.com."] = 1
a["imeem.com."] = 1
a["in.com."] = 1
a["incredimail.com."] = 1
a["indiatimes.com."] = 1
a["infoseek.co.jp."] = 1
a["interia.pl."] = 1
a["irctc.co.in."] = 1
a["isohunt.com."] = 1
a["it168.com."] = 1
a["it.com.cn."] = 1
a["joshmadecash.com."] = 1
a["jugem.jp."] = 1
a["justin.tv."] = 1
a["kaixin001.com."] = 1
a["kakaku.com."] = 1
a["kaskus.us."] = 1
a["keezmovies.com."] = 1
a["keyrun.com."] = 1
a["kooora.com."] = 1
a["ku6.com."] = 1
a["last.fm."] = 1
a["latimes.com."] = 1
a["leboncoin.fr."] = 1
a["leo.org."] = 1
a["letitbit.net."] = 1
a["libero.it."] = 1
a["linkbucks.com."] = 1
a["linkedin.com."] = 1
a["linternaute.com."] = 1
a["live.com."] = 1
a["livedoor.biz."] = 1
a["livedoor.com."] = 1
a["liveinternet.ru."] = 1
a["livejasmin.com."] = 1
a["livejournal.com."] = 1
a["livescore.com."] = 1
a["lo.st."] = 1
a["mail.ru."] = 1
a["maktoob.com."] = 1
a["mapquest.com."] = 1
a["marca.com."] = 1
a["marketgid.com."] = 1
a["match.com."] = 1
a["mediafire.com."] = 1
a["media-servers.net."] = 1
a["megaclick.com."] = 1
a["megaporn.com."] = 1
a["megaupload.com."] = 1
a["megavideo.com."] = 1
a["meinvz.net."] = 1
a["mercadolibre.com.mx."] = 1
a["mercadolivre.com.br."] = 1
a["metacafe.com."] = 1
a["metroflog.com."] = 1
a["metrolyrics.com."] = 1
a["microsoft.com."] = 1
a["milliyet.com.tr."] = 1
a["miniclip.com."] = 1
a["mininova.org."] = 1
a["mixi.jp."] = 1
a["mixx.com."] = 1
a["mlb.com."] = 1
a["mobile.de."] = 1
a["monster.com."] = 1
a["mop.com."] = 1
a["mozilla.com."] = 1
a["msn.ca."] = 1
a["msn.co.jp."] = 1
a["msn.com."] = 1
a["mtv.com."] = 1
a["multiply.com."] = 1
a["musica.com."] = 1
a["mybrute.com."] = 1
a["myegy.com."] = 1
a["myfreepaysite.com."] = 1
a["mynet.com."] = 1
a["myspace.com."] = 1
a["mywebsearch.com."] = 1
a["narod.ru."] = 1
a["nasza-klasa.pl."] = 1
a["nate.com."] = 1
a["naukri.com."] = 1
a["naver.com."] = 1
a["nba.com."] = 1
a["netflix.com."] = 1
a["netlog.com."] = 1
a["newegg.com."] = 1
a["news.com.au."] = 1
a["nextag.com."] = 1
a["nicovideo.jp."] = 1
a["nifty.com."] = 1
a["nih.gov."] = 1
a["ninemsn.com.au."] = 1
a["ning.com."] = 1
a["nytimes.com."] = 1
a["ocn.ne.jp."] = 1
a["odnoklassniki.ru."] = 1
a["onemanga.com."] = 1
a["onet.pl."] = 1
a["opendns.com."] = 1
a["orange.fr."] = 1
a["orkut.co.in."] = 1
a["orkut.com."] = 1
a["orkut.com.br."] = 1
a["over-blog.com."] = 1
a["paipai.com."] = 1
a["pandora.com."] = 1
a["partypoker.com."] = 1
a["passport.net."] = 1
a["paypal.com."] = 1
a["paypopup.com."] = 1
a["payserve.com."] = 1
a["pcgames.com.cn."] = 1
a["pchome.net."] = 1
a["pconline.com.cn."] = 1
a["pcpop.com."] = 1
a["people.com."] = 1
a["people.com.cn."] = 1
a["perezhilton.com."] = 1
a["perfspot.com."] = 1
a["photobucket.com."] = 1
a["pichunter.com."] = 1
a["plentyoffish.com."] = 1
a["pogo.com."] = 1
a["pornhub.com."] = 1
a["qip.ru."] = 1
a["qq.com."] = 1
a["radikal.ru."] = 1
a["rakuten.co.jp."] = 1
a["rambler.ru."] = 1
a["rapidlibrary.com."] = 1
a["rapidshare.com."] = 1
a["real.com."] = 1
a["realitykings.com."] = 1
a["rediff.com."] = 1
a["redtube.com."] = 1
a["reference.com."] = 1
a["repubblica.it."] = 1
a["reuters.com."] = 1
a["rmxads.com."] = 1
a["rr.com."] = 1
a["runescape.com."] = 1
a["sakura.ne.jp."] = 1
a["sanook.com."] = 1
a["sapo.pt."] = 1
a["schuelervz.net."] = 1
a["scribd.com."] = 1
a["secureserver.net."] = 1
a["seesaa.net."] = 1
a["sendspace.com."] = 1
a["seznam.cz."] = 1
a["sina.com.cn."] = 1
a["skype.com."] = 1
a["skyrock.com."] = 1
a["slide.com."] = 1
a["softonic.com."] = 1
a["softpedia.com."] = 1
a["sogou.com."] = 1
a["sohu.com."] = 1
a["so-net.ne.jp."] = 1
a["sonico.com."] = 1
a["soso.com."] = 1
a["soufun.com."] = 1
a["sourceforge.net."] = 1
a["spankwire.com."] = 1
a["spiegel.de."] = 1
a["statcounter.com."] = 1
a["studiverzeichnis.com."] = 1
a["stumbleupon.com."] = 1
a["sun.com."] = 1
a["sweetim.com."] = 1
a["symantec.com."] = 1
a["tagged.com."] = 1
a["taobao.com."] = 1
a["target.com."] = 1
a["taringa.net."] = 1
a["telegraph.co.uk."] = 1
a["terra.com.br."] = 1
a["thefreedictionary.com."] = 1
a["thepiratebay.org."] = 1
a["theplanet.com."] = 1
a["tianya.cn."] = 1
a["timesonline.co.uk."] = 1
a["tinypic.com."] = 1
a["tinyurl.com."] = 1
a["tnaflix.com."] = 1
a["tom.com."] = 1
a["t-online.de."] = 1
a["torrentreactor.net."] = 1
a["torrentz.com."] = 1
a["travian.ae."] = 1
a["travian.com."] = 1
a["tribalfusion.com."] = 1
a["tripadvisor.com."] = 1
a["tripod.com."] = 1
a["truveo.com."] = 1
a["tube8.com."] = 1
a["tudou.com."] = 1
a["tuenti.com."] = 1
a["twitpic.com."] = 1
a["twitter.com."] = 1
a["typepad.com."] = 1
a["ucoz.ru."] = 1
a["univision.com."] = 1
a["uol.com.br."] = 1
a["uploading.com."] = 1
a["ups.com."] = 1
a["usercash.com."] = 1
a["usps.com."] = 1
a["veoh.com."] = 1
a["verizon.net."] = 1
a["verycd.com."] = 1
a["vimeo.com."] = 1
a["virgilio.it."] = 1
a["vkontakte.ru."] = 1
a["vmn.net."] = 1
a["vnet.cn."] = 1
a["vnexpress.net."] = 1
a["walmart.com."] = 1
a["wamba.com."] = 1
a["washingtonpost.com."] = 1
a["weather.com."] = 1
a["web.de."] = 1
a["webs.com."] = 1
a["webshots.com."] = 1
a["wer-kennt-wen.de."] = 1
a["wikia.com."] = 1
a["wikimedia.org."] = 1
a["wikipedia.org."] = 1
a["wordpress.com."] = 1
a["wordreference.com."] = 1
a["wp.pl."] = 1
a["wretch.cc."] = 1
a["wsj.com."] = 1
a["wwe.com."] = 1
a["xanga.com."] = 1
a["xe.com."] = 1
a["xhamster.com."] = 1
a["xiaonei.com."] = 1
a["xing.com."] = 1
a["xinhuanet.com."] = 1
a["xnxx.com."] = 1
a["xtendmedia.com."] = 1
a["xtube.com."] = 1
a["xunlei.com."] = 1
a["xvideos.com."] = 1
a["y8.com."] = 1
a["yahoo.co.jp."] = 1
a["yahoo.com."] = 1
a["yahoo.com.cn."] = 1
a["yam.com."] = 1
a["yandex.ru."] = 1
a["yaplog.jp."] = 1
a["ya.ru."] = 1
a["yelp.com."] = 1
a["yesky.com."] = 1
a["yieldmanager.com."] = 1
a["yimg.com."] = 1
a["ynet.com."] = 1
a["youdao.com."] = 1
a["youjizz.com."] = 1
a["youku.com."] = 1
a["youporn.com."] = 1
a["yourfilehost.com."] = 1
a["youtube.com."] = 1
a["zaycev.net."] = 1
a["zedo.com."] = 1
a["ziddu.com."] = 1
a["zimbio.com."] = 1
a["zing.vn."] = 1
a["zol.com.cn."] = 1
a["zshare.net."] = 1
a["zylom.com."] = 1
a["zynga.com."] = 1
}

{a[$1] = 0}

END {
for(b in a) {if(a[b]==1){print b} }
}

