/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __COORD_H__
#define __COORD_H__

#include <cmath>
#include "globals.h"
#include <cassert>

using namespace std;

/**
 * A Class for coordinates both in terrain-space and in pixel-space. Stores the values internally as doubles but
 * external access is by integers.
 *
 * \author Tommi Tervonen <tommi@medusa.tutka.net>
 */
class coord
{
 protected:
  double x;
  double y;

  coord (double x, double y);
 public:
  /**
   * Generates a coordinate in pixel-coordinate space.
   */
  static coord pc (int x, int y);
  /**
   * Generates a coordinate in terrain-coordinate space.
   */
  static coord tc (int x, int y);

  coord (); // coord (0,0)
  coord (const coord &c); // copy constructor

  double dist (const coord &c) const; // eucl. dist from other coord
  double len () const; // eucl. dist from (0,0)

  bool tile_eq(const coord &oth);
  coord operator/ (double divider) const;
  coord& operator*= (double amount);
  coord operator* (double amount) const;
  coord operator- (const coord &c) const;
  coord operator+ (const coord &c) const;
  coord& operator-= (const coord &c);
  coord& operator= (const coord &c);
  coord& operator+= (const coord &c);
  bool operator== (const coord &c) const;
  bool operator!= (const coord &c) const;
  int getPX() const;
  int getPY() const;
  int getTX() const;
  int getTY() const;

  void setPX(int val);
  void setPY(int val);
  void setTX(int val);
  void setTY(int val);

  void incTX();
  void incTY();
  void decTX();
  void decTY();

  void incPX();
  void incPY();
  void decPX();
  void decPY();

  void addPX(double am);
  void addPY(double am);
  void addTX(int am);
  void addTY(int am);

  void subPX(double am);
  void subPY(double am);
  void subTX(int am);
  void subTY(int am);

};

#endif
