---
myst:
  html_meta:
    "description lang=en": |
      Reference for writing documentation
---
# Documentation

This section contains links and explanations for writing documentation.

## Markdown/MyST files

The documentation files with `.md` are structured using [Markdown] and [MyST].

## reStructuredText files

[reStructuredText] is used for `.rst` files to include the source code using [Sphinx].

## Source code

The source code is written in Python and tested with [doctest].
The format of the docstrings follows [Google's style guide].

[Markdown]: https://www.markdownguide.org/cheat-sheet/
[reStructuredText]: https://github.com/ralsina/rst-cheatsheet/blob/master/rst-cheatsheet.rst
[MyST]: https://mystmd.org/
[Sphinx]: https://www.sphinx-doc.org/
[doctest]: https://docs.python.org/3/library/doctest.html
[Google's style guide]: https://google.github.io/styleguide/pyguide.html#383-functions-and-methods
