// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSummary_MoveTo(t *testing.T) {
	ms := generateTestSummary()
	dest := NewSummary()
	ms.MoveTo(dest)
	assert.Equal(t, NewSummary(), ms)
	assert.Equal(t, generateTestSummary(), dest)
}

func TestSummary_CopyTo(t *testing.T) {
	ms := NewSummary()
	orig := NewSummary()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSummary()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestSummary_DataPoints(t *testing.T) {
	ms := NewSummary()
	assert.Equal(t, NewSummaryDataPointSlice(), ms.DataPoints())
	fillTestSummaryDataPointSlice(ms.DataPoints())
	assert.Equal(t, generateTestSummaryDataPointSlice(), ms.DataPoints())
}

func generateTestSummary() Summary {
	tv := NewSummary()
	fillTestSummary(tv)
	return tv
}

func fillTestSummary(tv Summary) {
	fillTestSummaryDataPointSlice(newSummaryDataPointSlice(&tv.orig.DataPoints))
}
