package datacollectionapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-09-01-preview/datacollection"
	"github.com/Azure/go-autorest/autorest"
)

// EndpointsClientAPI contains the set of methods on the EndpointsClient type.
type EndpointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string, body *datacollection.EndpointResource) (result datacollection.EndpointResource, err error)
	Delete(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result datacollection.EndpointResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result datacollection.EndpointResourceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result datacollection.EndpointResourceListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result datacollection.EndpointResourceListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result datacollection.EndpointResourceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string, body *datacollection.ResourceForUpdate) (result datacollection.EndpointResource, err error)
}

var _ EndpointsClientAPI = (*datacollection.EndpointsClient)(nil)

// RuleAssociationsClientAPI contains the set of methods on the RuleAssociationsClient type.
type RuleAssociationsClientAPI interface {
	Create(ctx context.Context, resourceURI string, associationName string, body *datacollection.RuleAssociationProxyOnlyResource) (result datacollection.RuleAssociationProxyOnlyResource, err error)
	Delete(ctx context.Context, resourceURI string, associationName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceURI string, associationName string) (result datacollection.RuleAssociationProxyOnlyResource, err error)
	ListByDataCollectionEndpoint(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result datacollection.RuleAssociationProxyOnlyResourceListResultPage, err error)
	ListByDataCollectionEndpointComplete(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result datacollection.RuleAssociationProxyOnlyResourceListResultIterator, err error)
	ListByResource(ctx context.Context, resourceURI string) (result datacollection.RuleAssociationProxyOnlyResourceListResultPage, err error)
	ListByResourceComplete(ctx context.Context, resourceURI string) (result datacollection.RuleAssociationProxyOnlyResourceListResultIterator, err error)
	ListByRule(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result datacollection.RuleAssociationProxyOnlyResourceListResultPage, err error)
	ListByRuleComplete(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result datacollection.RuleAssociationProxyOnlyResourceListResultIterator, err error)
}

var _ RuleAssociationsClientAPI = (*datacollection.RuleAssociationsClient)(nil)

// RulesClientAPI contains the set of methods on the RulesClient type.
type RulesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, dataCollectionRuleName string, body *datacollection.RuleResource) (result datacollection.RuleResource, err error)
	Delete(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result datacollection.RuleResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result datacollection.RuleResourceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result datacollection.RuleResourceListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result datacollection.RuleResourceListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result datacollection.RuleResourceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, dataCollectionRuleName string, body *datacollection.ResourceForUpdate) (result datacollection.RuleResource, err error)
}

var _ RulesClientAPI = (*datacollection.RulesClient)(nil)
