package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterHealthReport invokes the adb.DescribeDBClusterHealthReport API synchronously
func (client *Client) DescribeDBClusterHealthReport(request *DescribeDBClusterHealthReportRequest) (response *DescribeDBClusterHealthReportResponse, err error) {
	response = CreateDescribeDBClusterHealthReportResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterHealthReportWithChan invokes the adb.DescribeDBClusterHealthReport API asynchronously
func (client *Client) DescribeDBClusterHealthReportWithChan(request *DescribeDBClusterHealthReportRequest) (<-chan *DescribeDBClusterHealthReportResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterHealthReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterHealthReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterHealthReportWithCallback invokes the adb.DescribeDBClusterHealthReport API asynchronously
func (client *Client) DescribeDBClusterHealthReportWithCallback(request *DescribeDBClusterHealthReportRequest, callback func(response *DescribeDBClusterHealthReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterHealthReportResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterHealthReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterHealthReportRequest is the request struct for api DescribeDBClusterHealthReport
type DescribeDBClusterHealthReportRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
	StartTime   string `position:"Query" name:"StartTime"`
}

// DescribeDBClusterHealthReportResponse is the response struct for api DescribeDBClusterHealthReport
type DescribeDBClusterHealthReportResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Items     []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeDBClusterHealthReportRequest creates a request to invoke DescribeDBClusterHealthReport API
func CreateDescribeDBClusterHealthReportRequest() (request *DescribeDBClusterHealthReportRequest) {
	request = &DescribeDBClusterHealthReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterHealthReport", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterHealthReportResponse creates a response to parse from DescribeDBClusterHealthReport response
func CreateDescribeDBClusterHealthReportResponse() (response *DescribeDBClusterHealthReportResponse) {
	response = &DescribeDBClusterHealthReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
