package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulTargetStatistics invokes the aegis.DescribeVulTargetStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describevultargetstatistics.html
func (client *Client) DescribeVulTargetStatistics(request *DescribeVulTargetStatisticsRequest) (response *DescribeVulTargetStatisticsResponse, err error) {
	response = CreateDescribeVulTargetStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulTargetStatisticsWithChan invokes the aegis.DescribeVulTargetStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevultargetstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulTargetStatisticsWithChan(request *DescribeVulTargetStatisticsRequest) (<-chan *DescribeVulTargetStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeVulTargetStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulTargetStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulTargetStatisticsWithCallback invokes the aegis.DescribeVulTargetStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevultargetstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulTargetStatisticsWithCallback(request *DescribeVulTargetStatisticsRequest, callback func(response *DescribeVulTargetStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulTargetStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulTargetStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulTargetStatisticsRequest is the request struct for api DescribeVulTargetStatistics
type DescribeVulTargetStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Type     string `position:"Query" name:"Type"`
}

// DescribeVulTargetStatisticsResponse is the response struct for api DescribeVulTargetStatistics
type DescribeVulTargetStatisticsResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	CurrentPage int          `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	TargetStats []TargetStat `json:"TargetStats" xml:"TargetStats"`
}

// CreateDescribeVulTargetStatisticsRequest creates a request to invoke DescribeVulTargetStatistics API
func CreateDescribeVulTargetStatisticsRequest() (request *DescribeVulTargetStatisticsRequest) {
	request = &DescribeVulTargetStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeVulTargetStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeVulTargetStatisticsResponse creates a response to parse from DescribeVulTargetStatistics response
func CreateDescribeVulTargetStatisticsResponse() (response *DescribeVulTargetStatisticsResponse) {
	response = &DescribeVulTargetStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
