package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLicenseKey invokes the ahas_openapi.GetLicenseKey API synchronously
func (client *Client) GetLicenseKey(request *GetLicenseKeyRequest) (response *GetLicenseKeyResponse, err error) {
	response = CreateGetLicenseKeyResponse()
	err = client.DoAction(request, response)
	return
}

// GetLicenseKeyWithChan invokes the ahas_openapi.GetLicenseKey API asynchronously
func (client *Client) GetLicenseKeyWithChan(request *GetLicenseKeyRequest) (<-chan *GetLicenseKeyResponse, <-chan error) {
	responseChan := make(chan *GetLicenseKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLicenseKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLicenseKeyWithCallback invokes the ahas_openapi.GetLicenseKey API asynchronously
func (client *Client) GetLicenseKeyWithCallback(request *GetLicenseKeyRequest, callback func(response *GetLicenseKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLicenseKeyResponse
		var err error
		defer close(result)
		response, err = client.GetLicenseKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLicenseKeyRequest is the request struct for api GetLicenseKey
type GetLicenseKeyRequest struct {
	*requests.RpcRequest
	AhasRegionId string `position:"Query" name:"AhasRegionId"`
	Namespace    string `position:"Query" name:"Namespace"`
}

// GetLicenseKeyResponse is the response struct for api GetLicenseKey
type GetLicenseKeyResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetLicenseKeyRequest creates a request to invoke GetLicenseKey API
func CreateGetLicenseKeyRequest() (request *GetLicenseKeyRequest) {
	request = &GetLicenseKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "GetLicenseKey", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLicenseKeyResponse creates a response to parse from GetLicenseKey response
func CreateGetLicenseKeyResponse() (response *GetLicenseKeyResponse) {
	response = &GetLicenseKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
