package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteOssFile invokes the apds.DeleteOssFile API synchronously
func (client *Client) DeleteOssFile(request *DeleteOssFileRequest) (response *DeleteOssFileResponse, err error) {
	response = CreateDeleteOssFileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteOssFileWithChan invokes the apds.DeleteOssFile API asynchronously
func (client *Client) DeleteOssFileWithChan(request *DeleteOssFileRequest) (<-chan *DeleteOssFileResponse, <-chan error) {
	responseChan := make(chan *DeleteOssFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteOssFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteOssFileWithCallback invokes the apds.DeleteOssFile API asynchronously
func (client *Client) DeleteOssFileWithCallback(request *DeleteOssFileRequest, callback func(response *DeleteOssFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteOssFileResponse
		var err error
		defer close(result)
		response, err = client.DeleteOssFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteOssFileRequest is the request struct for api DeleteOssFile
type DeleteOssFileRequest struct {
	*requests.RoaRequest
	ObjectName string `position:"Query" name:"objectName"`
}

// DeleteOssFileResponse is the response struct for api DeleteOssFile
type DeleteOssFileResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDeleteOssFileRequest creates a request to invoke DeleteOssFile API
func CreateDeleteOssFileRequest() (request *DeleteOssFileRequest) {
	request = &DeleteOssFileRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DeleteOssFile", "/okss-services/file-job/delete-file", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteOssFileResponse creates a response to parse from DeleteOssFile response
func CreateDeleteOssFileResponse() (response *DeleteOssFileResponse) {
	response = &DeleteOssFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
