package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWirelessCloudConnector invokes the cc5g.DeleteWirelessCloudConnector API synchronously
func (client *Client) DeleteWirelessCloudConnector(request *DeleteWirelessCloudConnectorRequest) (response *DeleteWirelessCloudConnectorResponse, err error) {
	response = CreateDeleteWirelessCloudConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWirelessCloudConnectorWithChan invokes the cc5g.DeleteWirelessCloudConnector API asynchronously
func (client *Client) DeleteWirelessCloudConnectorWithChan(request *DeleteWirelessCloudConnectorRequest) (<-chan *DeleteWirelessCloudConnectorResponse, <-chan error) {
	responseChan := make(chan *DeleteWirelessCloudConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWirelessCloudConnector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWirelessCloudConnectorWithCallback invokes the cc5g.DeleteWirelessCloudConnector API asynchronously
func (client *Client) DeleteWirelessCloudConnectorWithCallback(request *DeleteWirelessCloudConnectorRequest, callback func(response *DeleteWirelessCloudConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWirelessCloudConnectorResponse
		var err error
		defer close(result)
		response, err = client.DeleteWirelessCloudConnector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWirelessCloudConnectorRequest is the request struct for api DeleteWirelessCloudConnector
type DeleteWirelessCloudConnectorRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// DeleteWirelessCloudConnectorResponse is the response struct for api DeleteWirelessCloudConnector
type DeleteWirelessCloudConnectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteWirelessCloudConnectorRequest creates a request to invoke DeleteWirelessCloudConnector API
func CreateDeleteWirelessCloudConnectorRequest() (request *DeleteWirelessCloudConnectorRequest) {
	request = &DeleteWirelessCloudConnectorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "DeleteWirelessCloudConnector", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteWirelessCloudConnectorResponse creates a response to parse from DeleteWirelessCloudConnector response
func CreateDeleteWirelessCloudConnectorResponse() (response *DeleteWirelessCloudConnectorResponse) {
	response = &DeleteWirelessCloudConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
