package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSkillGroup invokes the ccc.GetSkillGroup API synchronously
func (client *Client) GetSkillGroup(request *GetSkillGroupRequest) (response *GetSkillGroupResponse, err error) {
	response = CreateGetSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetSkillGroupWithChan invokes the ccc.GetSkillGroup API asynchronously
func (client *Client) GetSkillGroupWithChan(request *GetSkillGroupRequest) (<-chan *GetSkillGroupResponse, <-chan error) {
	responseChan := make(chan *GetSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSkillGroupWithCallback invokes the ccc.GetSkillGroup API asynchronously
func (client *Client) GetSkillGroupWithCallback(request *GetSkillGroupRequest, callback func(response *GetSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.GetSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSkillGroupRequest is the request struct for api GetSkillGroup
type GetSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
}

// GetSkillGroupResponse is the response struct for api GetSkillGroup
type GetSkillGroupResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetSkillGroupRequest creates a request to invoke GetSkillGroup API
func CreateGetSkillGroupRequest() (request *GetSkillGroupRequest) {
	request = &GetSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSkillGroupResponse creates a response to parse from GetSkillGroup response
func CreateGetSkillGroupResponse() (response *GetSkillGroupResponse) {
	response = &GetSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
