package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLorneTask invokes the clickhouse.DeleteLorneTask API synchronously
func (client *Client) DeleteLorneTask(request *DeleteLorneTaskRequest) (response *DeleteLorneTaskResponse, err error) {
	response = CreateDeleteLorneTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLorneTaskWithChan invokes the clickhouse.DeleteLorneTask API asynchronously
func (client *Client) DeleteLorneTaskWithChan(request *DeleteLorneTaskRequest) (<-chan *DeleteLorneTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteLorneTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLorneTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLorneTaskWithCallback invokes the clickhouse.DeleteLorneTask API asynchronously
func (client *Client) DeleteLorneTaskWithCallback(request *DeleteLorneTaskRequest, callback func(response *DeleteLorneTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLorneTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteLorneTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLorneTaskRequest is the request struct for api DeleteLorneTask
type DeleteLorneTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLorneTaskResponse is the response struct for api DeleteLorneTask
type DeleteLorneTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLorneTaskRequest creates a request to invoke DeleteLorneTask API
func CreateDeleteLorneTaskRequest() (request *DeleteLorneTaskRequest) {
	request = &DeleteLorneTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DeleteLorneTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLorneTaskResponse creates a response to parse from DeleteLorneTask response
func CreateDeleteLorneTaskResponse() (response *DeleteLorneTaskResponse) {
	response = &DeleteLorneTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
