package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApi invokes the cloudapi.DescribeApi API synchronously
func (client *Client) DescribeApi(request *DescribeApiRequest) (response *DescribeApiResponse, err error) {
	response = CreateDescribeApiResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiWithChan invokes the cloudapi.DescribeApi API asynchronously
func (client *Client) DescribeApiWithChan(request *DescribeApiRequest) (<-chan *DescribeApiResponse, <-chan error) {
	responseChan := make(chan *DescribeApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiWithCallback invokes the cloudapi.DescribeApi API asynchronously
func (client *Client) DescribeApiWithCallback(request *DescribeApiRequest, callback func(response *DescribeApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiResponse
		var err error
		defer close(result)
		response, err = client.DescribeApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiRequest is the request struct for api DescribeApi
type DescribeApiRequest struct {
	*requests.RpcRequest
	GroupId            string `position:"Query" name:"GroupId"`
	ResourceOwnerToken string `position:"Query" name:"ResourceOwnerToken"`
	SecurityToken      string `position:"Query" name:"SecurityToken"`
	ApiId              string `position:"Query" name:"ApiId"`
}

// DescribeApiResponse is the response struct for api DescribeApi
type DescribeApiResponse struct {
	*responses.BaseResponse
	ApiId                  string                              `json:"ApiId" xml:"ApiId"`
	ResultType             string                              `json:"ResultType" xml:"ResultType"`
	WebSocketApiType       string                              `json:"WebSocketApiType" xml:"WebSocketApiType"`
	DisableInternet        bool                                `json:"DisableInternet" xml:"DisableInternet"`
	ResultBodyModel        string                              `json:"ResultBodyModel" xml:"ResultBodyModel"`
	ResultSample           string                              `json:"ResultSample" xml:"ResultSample"`
	AppCodeAuthType        string                              `json:"AppCodeAuthType" xml:"AppCodeAuthType"`
	AllowSignatureMethod   string                              `json:"AllowSignatureMethod" xml:"AllowSignatureMethod"`
	RegionId               string                              `json:"RegionId" xml:"RegionId"`
	ForceNonceCheck        bool                                `json:"ForceNonceCheck" xml:"ForceNonceCheck"`
	Visibility             string                              `json:"Visibility" xml:"Visibility"`
	FailResultSample       string                              `json:"FailResultSample" xml:"FailResultSample"`
	AuthType               string                              `json:"AuthType" xml:"AuthType"`
	ModifiedTime           string                              `json:"ModifiedTime" xml:"ModifiedTime"`
	RequestId              string                              `json:"RequestId" xml:"RequestId"`
	Description            string                              `json:"Description" xml:"Description"`
	GroupName              string                              `json:"GroupName" xml:"GroupName"`
	GroupId                string                              `json:"GroupId" xml:"GroupId"`
	Mock                   string                              `json:"Mock" xml:"Mock"`
	MockResult             string                              `json:"MockResult" xml:"MockResult"`
	CreatedTime            string                              `json:"CreatedTime" xml:"CreatedTime"`
	ApiName                string                              `json:"ApiName" xml:"ApiName"`
	BackendEnable          bool                                `json:"BackendEnable" xml:"BackendEnable"`
	BackendConfig          BackendConfig                       `json:"BackendConfig" xml:"BackendConfig"`
	RequestConfig          RequestConfig                       `json:"RequestConfig" xml:"RequestConfig"`
	ServiceConfig          ServiceConfig                       `json:"ServiceConfig" xml:"ServiceConfig"`
	OpenIdConnectConfig    OpenIdConnectConfig                 `json:"OpenIdConnectConfig" xml:"OpenIdConnectConfig"`
	ErrorCodeSamples       ErrorCodeSamplesInDescribeApi       `json:"ErrorCodeSamples" xml:"ErrorCodeSamples"`
	ResultDescriptions     ResultDescriptionsInDescribeApi     `json:"ResultDescriptions" xml:"ResultDescriptions"`
	SystemParameters       SystemParametersInDescribeApi       `json:"SystemParameters" xml:"SystemParameters"`
	CustomSystemParameters CustomSystemParametersInDescribeApi `json:"CustomSystemParameters" xml:"CustomSystemParameters"`
	ConstantParameters     ConstantParametersInDescribeApi     `json:"ConstantParameters" xml:"ConstantParameters"`
	RequestParameters      RequestParametersInDescribeApi      `json:"RequestParameters" xml:"RequestParameters"`
	ServiceParameters      ServiceParametersInDescribeApi      `json:"ServiceParameters" xml:"ServiceParameters"`
	ServiceParametersMap   ServiceParametersMapInDescribeApi   `json:"ServiceParametersMap" xml:"ServiceParametersMap"`
	DeployedInfos          DeployedInfosInDescribeApi          `json:"DeployedInfos" xml:"DeployedInfos"`
}

// CreateDescribeApiRequest creates a request to invoke DescribeApi API
func CreateDescribeApiRequest() (request *DescribeApiRequest) {
	request = &DescribeApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApi", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApiResponse creates a response to parse from DescribeApi response
func CreateDescribeApiResponse() (response *DescribeApiResponse) {
	response = &DescribeApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
