package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVnCategory invokes the cloudcallcenter.CreateVnCategory API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvncategory.html
func (client *Client) CreateVnCategory(request *CreateVnCategoryRequest) (response *CreateVnCategoryResponse, err error) {
	response = CreateCreateVnCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVnCategoryWithChan invokes the cloudcallcenter.CreateVnCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvncategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnCategoryWithChan(request *CreateVnCategoryRequest) (<-chan *CreateVnCategoryResponse, <-chan error) {
	responseChan := make(chan *CreateVnCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVnCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVnCategoryWithCallback invokes the cloudcallcenter.CreateVnCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvncategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnCategoryWithCallback(request *CreateVnCategoryRequest, callback func(response *CreateVnCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVnCategoryResponse
		var err error
		defer close(result)
		response, err = client.CreateVnCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVnCategoryRequest is the request struct for api CreateVnCategory
type CreateVnCategoryRequest struct {
	*requests.RpcRequest
	ParentId   string `position:"Query" name:"ParentId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Name       string `position:"Query" name:"Name"`
}

// CreateVnCategoryResponse is the response struct for api CreateVnCategory
type CreateVnCategoryResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	CategoryId string `json:"CategoryId" xml:"CategoryId"`
}

// CreateCreateVnCategoryRequest creates a request to invoke CreateVnCategory API
func CreateCreateVnCategoryRequest() (request *CreateVnCategoryRequest) {
	request = &CreateVnCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateVnCategory", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateVnCategoryResponse creates a response to parse from CreateVnCategory response
func CreateCreateVnCategoryResponse() (response *CreateVnCategoryResponse) {
	response = &CreateVnCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
