package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCompanyTemplatePictureByJob invokes the cloudesl.GetCompanyTemplatePictureByJob API synchronously
func (client *Client) GetCompanyTemplatePictureByJob(request *GetCompanyTemplatePictureByJobRequest) (response *GetCompanyTemplatePictureByJobResponse, err error) {
	response = CreateGetCompanyTemplatePictureByJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetCompanyTemplatePictureByJobWithChan invokes the cloudesl.GetCompanyTemplatePictureByJob API asynchronously
func (client *Client) GetCompanyTemplatePictureByJobWithChan(request *GetCompanyTemplatePictureByJobRequest) (<-chan *GetCompanyTemplatePictureByJobResponse, <-chan error) {
	responseChan := make(chan *GetCompanyTemplatePictureByJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCompanyTemplatePictureByJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCompanyTemplatePictureByJobWithCallback invokes the cloudesl.GetCompanyTemplatePictureByJob API asynchronously
func (client *Client) GetCompanyTemplatePictureByJobWithCallback(request *GetCompanyTemplatePictureByJobRequest, callback func(response *GetCompanyTemplatePictureByJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCompanyTemplatePictureByJobResponse
		var err error
		defer close(result)
		response, err = client.GetCompanyTemplatePictureByJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCompanyTemplatePictureByJobRequest is the request struct for api GetCompanyTemplatePictureByJob
type GetCompanyTemplatePictureByJobRequest struct {
	*requests.RpcRequest
	JobId string `position:"Body" name:"JobId"`
}

// GetCompanyTemplatePictureByJobResponse is the response struct for api GetCompanyTemplatePictureByJob
type GetCompanyTemplatePictureByJobResponse struct {
	*responses.BaseResponse
	Base64Picture  string `json:"Base64Picture" xml:"Base64Picture"`
	JobId          string `json:"JobId" xml:"JobId"`
	Type           string `json:"Type" xml:"Type"`
	Url            string `json:"Url" xml:"Url"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateGetCompanyTemplatePictureByJobRequest creates a request to invoke GetCompanyTemplatePictureByJob API
func CreateGetCompanyTemplatePictureByJobRequest() (request *GetCompanyTemplatePictureByJobRequest) {
	request = &GetCompanyTemplatePictureByJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "GetCompanyTemplatePictureByJob", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCompanyTemplatePictureByJobResponse creates a response to parse from GetCompanyTemplatePictureByJob response
func CreateGetCompanyTemplatePictureByJobResponse() (response *GetCompanyTemplatePictureByJobResponse) {
	response = &GetCompanyTemplatePictureByJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
