package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSimilarPhotos invokes the cloudphoto.GetSimilarPhotos API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/getsimilarphotos.html
func (client *Client) GetSimilarPhotos(request *GetSimilarPhotosRequest) (response *GetSimilarPhotosResponse, err error) {
	response = CreateGetSimilarPhotosResponse()
	err = client.DoAction(request, response)
	return
}

// GetSimilarPhotosWithChan invokes the cloudphoto.GetSimilarPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getsimilarphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSimilarPhotosWithChan(request *GetSimilarPhotosRequest) (<-chan *GetSimilarPhotosResponse, <-chan error) {
	responseChan := make(chan *GetSimilarPhotosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSimilarPhotos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSimilarPhotosWithCallback invokes the cloudphoto.GetSimilarPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getsimilarphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSimilarPhotosWithCallback(request *GetSimilarPhotosRequest, callback func(response *GetSimilarPhotosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSimilarPhotosResponse
		var err error
		defer close(result)
		response, err = client.GetSimilarPhotos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSimilarPhotosRequest is the request struct for api GetSimilarPhotos
type GetSimilarPhotosRequest struct {
	*requests.RpcRequest
	LibraryId string           `position:"Query" name:"LibraryId"`
	PhotoId   requests.Integer `position:"Query" name:"PhotoId"`
	StoreName string           `position:"Query" name:"StoreName"`
}

// GetSimilarPhotosResponse is the response struct for api GetSimilarPhotos
type GetSimilarPhotosResponse struct {
	*responses.BaseResponse
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Action    string  `json:"Action" xml:"Action"`
	Photos    []Photo `json:"Photos" xml:"Photos"`
}

// CreateGetSimilarPhotosRequest creates a request to invoke GetSimilarPhotos API
func CreateGetSimilarPhotosRequest() (request *GetSimilarPhotosRequest) {
	request = &GetSimilarPhotosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "GetSimilarPhotos", "cloudphoto", "openAPI")
	return
}

// CreateGetSimilarPhotosResponse creates a response to parse from GetSimilarPhotos response
func CreateGetSimilarPhotosResponse() (response *GetSimilarPhotosResponse) {
	response = &GetSimilarPhotosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
