package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPhotoTags invokes the cloudphoto.ListPhotoTags API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphototags.html
func (client *Client) ListPhotoTags(request *ListPhotoTagsRequest) (response *ListPhotoTagsResponse, err error) {
	response = CreateListPhotoTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPhotoTagsWithChan invokes the cloudphoto.ListPhotoTags API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphototags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoTagsWithChan(request *ListPhotoTagsRequest) (<-chan *ListPhotoTagsResponse, <-chan error) {
	responseChan := make(chan *ListPhotoTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPhotoTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPhotoTagsWithCallback invokes the cloudphoto.ListPhotoTags API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphototags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoTagsWithCallback(request *ListPhotoTagsRequest, callback func(response *ListPhotoTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPhotoTagsResponse
		var err error
		defer close(result)
		response, err = client.ListPhotoTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPhotoTagsRequest is the request struct for api ListPhotoTags
type ListPhotoTagsRequest struct {
	*requests.RpcRequest
	LibraryId string           `position:"Query" name:"LibraryId"`
	PhotoId   requests.Integer `position:"Query" name:"PhotoId"`
	StoreName string           `position:"Query" name:"StoreName"`
	Lang      string           `position:"Query" name:"Lang"`
}

// ListPhotoTagsResponse is the response struct for api ListPhotoTags
type ListPhotoTagsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Action    string `json:"Action" xml:"Action"`
	Tags      []Tag  `json:"Tags" xml:"Tags"`
}

// CreateListPhotoTagsRequest creates a request to invoke ListPhotoTags API
func CreateListPhotoTagsRequest() (request *ListPhotoTagsRequest) {
	request = &ListPhotoTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ListPhotoTags", "cloudphoto", "openAPI")
	return
}

// CreateListPhotoTagsResponse creates a response to parse from ListPhotoTags response
func CreateListPhotoTagsResponse() (response *ListPhotoTagsResponse) {
	response = &ListPhotoTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
