package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetScanMode invokes the cloudwf.SetScanMode API synchronously
// api document: https://help.aliyun.com/api/cloudwf/setscanmode.html
func (client *Client) SetScanMode(request *SetScanModeRequest) (response *SetScanModeResponse, err error) {
	response = CreateSetScanModeResponse()
	err = client.DoAction(request, response)
	return
}

// SetScanModeWithChan invokes the cloudwf.SetScanMode API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/setscanmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetScanModeWithChan(request *SetScanModeRequest) (<-chan *SetScanModeResponse, <-chan error) {
	responseChan := make(chan *SetScanModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetScanMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetScanModeWithCallback invokes the cloudwf.SetScanMode API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/setscanmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetScanModeWithCallback(request *SetScanModeRequest, callback func(response *SetScanModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetScanModeResponse
		var err error
		defer close(result)
		response, err = client.SetScanMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetScanModeRequest is the request struct for api SetScanMode
type SetScanModeRequest struct {
	*requests.RpcRequest
	Operation requests.Integer `position:"Query" name:"Operation"`
	MacList   *[]string        `position:"Query" name:"MacList"  type:"Repeated"`
}

// SetScanModeResponse is the response struct for api SetScanMode
type SetScanModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSetScanModeRequest creates a request to invoke SetScanMode API
func CreateSetScanModeRequest() (request *SetScanModeRequest) {
	request = &SetScanModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SetScanMode", "cloudwf", "openAPI")
	return
}

// CreateSetScanModeResponse creates a response to parse from SetScanMode response
func CreateSetScanModeResponse() (response *SetScanModeResponse) {
	response = &SetScanModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
