package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateResourceComplianceTimeline invokes the config.GetAggregateResourceComplianceTimeline API synchronously
func (client *Client) GetAggregateResourceComplianceTimeline(request *GetAggregateResourceComplianceTimelineRequest) (response *GetAggregateResourceComplianceTimelineResponse, err error) {
	response = CreateGetAggregateResourceComplianceTimelineResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateResourceComplianceTimelineWithChan invokes the config.GetAggregateResourceComplianceTimeline API asynchronously
func (client *Client) GetAggregateResourceComplianceTimelineWithChan(request *GetAggregateResourceComplianceTimelineRequest) (<-chan *GetAggregateResourceComplianceTimelineResponse, <-chan error) {
	responseChan := make(chan *GetAggregateResourceComplianceTimelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateResourceComplianceTimeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateResourceComplianceTimelineWithCallback invokes the config.GetAggregateResourceComplianceTimeline API asynchronously
func (client *Client) GetAggregateResourceComplianceTimelineWithCallback(request *GetAggregateResourceComplianceTimelineRequest, callback func(response *GetAggregateResourceComplianceTimelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateResourceComplianceTimelineResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateResourceComplianceTimeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateResourceComplianceTimelineRequest is the request struct for api GetAggregateResourceComplianceTimeline
type GetAggregateResourceComplianceTimelineRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AggregatorId    string           `position:"Query" name:"AggregatorId"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	NextToken       string           `position:"Query" name:"NextToken"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
	Region          string           `position:"Query" name:"Region"`
}

// GetAggregateResourceComplianceTimelineResponse is the response struct for api GetAggregateResourceComplianceTimeline
type GetAggregateResourceComplianceTimelineResponse struct {
	*responses.BaseResponse
	RequestId                  string                     `json:"RequestId" xml:"RequestId"`
	ResourceComplianceTimeline ResourceComplianceTimeline `json:"ResourceComplianceTimeline" xml:"ResourceComplianceTimeline"`
}

// CreateGetAggregateResourceComplianceTimelineRequest creates a request to invoke GetAggregateResourceComplianceTimeline API
func CreateGetAggregateResourceComplianceTimelineRequest() (request *GetAggregateResourceComplianceTimelineRequest) {
	request = &GetAggregateResourceComplianceTimelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateResourceComplianceTimeline", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateResourceComplianceTimelineResponse creates a response to parse from GetAggregateResourceComplianceTimeline response
func CreateGetAggregateResourceComplianceTimelineResponse() (response *GetAggregateResourceComplianceTimelineResponse) {
	response = &GetAggregateResourceComplianceTimelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
