package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSnapshotLinks invokes the dbfs.ListSnapshotLinks API synchronously
func (client *Client) ListSnapshotLinks(request *ListSnapshotLinksRequest) (response *ListSnapshotLinksResponse, err error) {
	response = CreateListSnapshotLinksResponse()
	err = client.DoAction(request, response)
	return
}

// ListSnapshotLinksWithChan invokes the dbfs.ListSnapshotLinks API asynchronously
func (client *Client) ListSnapshotLinksWithChan(request *ListSnapshotLinksRequest) (<-chan *ListSnapshotLinksResponse, <-chan error) {
	responseChan := make(chan *ListSnapshotLinksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSnapshotLinks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSnapshotLinksWithCallback invokes the dbfs.ListSnapshotLinks API asynchronously
func (client *Client) ListSnapshotLinksWithCallback(request *ListSnapshotLinksRequest, callback func(response *ListSnapshotLinksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSnapshotLinksResponse
		var err error
		defer close(result)
		response, err = client.ListSnapshotLinks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSnapshotLinksRequest is the request struct for api ListSnapshotLinks
type ListSnapshotLinksRequest struct {
	*requests.RpcRequest
	FilterValue string           `position:"Query" name:"FilterValue"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey   string           `position:"Query" name:"FilterKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListSnapshotLinksResponse is the response struct for api ListSnapshotLinks
type ListSnapshotLinksResponse struct {
	*responses.BaseResponse
	TotalCount    int    `json:"TotalCount" xml:"TotalCount"`
	PageSize      int    `json:"PageSize" xml:"PageSize"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	PageNumber    int    `json:"PageNumber" xml:"PageNumber"`
	SnapshotLinks []Info `json:"SnapshotLinks" xml:"SnapshotLinks"`
}

// CreateListSnapshotLinksRequest creates a request to invoke ListSnapshotLinks API
func CreateListSnapshotLinksRequest() (request *ListSnapshotLinksRequest) {
	request = &ListSnapshotLinksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListSnapshotLinks", "", "")
	request.Method = requests.POST
	return
}

// CreateListSnapshotLinksResponse creates a response to parse from ListSnapshotLinks response
func CreateListSnapshotLinksResponse() (response *ListSnapshotLinksResponse) {
	response = &ListSnapshotLinksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
