package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServerLock invokes the domain.ListServerLock API synchronously
func (client *Client) ListServerLock(request *ListServerLockRequest) (response *ListServerLockResponse, err error) {
	response = CreateListServerLockResponse()
	err = client.DoAction(request, response)
	return
}

// ListServerLockWithChan invokes the domain.ListServerLock API asynchronously
func (client *Client) ListServerLockWithChan(request *ListServerLockRequest) (<-chan *ListServerLockResponse, <-chan error) {
	responseChan := make(chan *ListServerLockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServerLock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServerLockWithCallback invokes the domain.ListServerLock API asynchronously
func (client *Client) ListServerLockWithCallback(request *ListServerLockRequest, callback func(response *ListServerLockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServerLockResponse
		var err error
		defer close(result)
		response, err = client.ListServerLock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServerLockRequest is the request struct for api ListServerLock
type ListServerLockRequest struct {
	*requests.RpcRequest
	LockProductId    string           `position:"Query" name:"LockProductId"`
	EndExpireDate    requests.Integer `position:"Query" name:"EndExpireDate"`
	PageNum          requests.Integer `position:"Query" name:"PageNum"`
	BeginStartDate   requests.Integer `position:"Query" name:"BeginStartDate"`
	ServerLockStatus requests.Integer `position:"Query" name:"ServerLockStatus"`
	StartExpireDate  requests.Integer `position:"Query" name:"StartExpireDate"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
	DomainName       string           `position:"Query" name:"DomainName"`
	EndStartDate     requests.Integer `position:"Query" name:"EndStartDate"`
	UserClientIp     string           `position:"Query" name:"UserClientIp"`
}

// ListServerLockResponse is the response struct for api ListServerLock
type ListServerLockResponse struct {
	*responses.BaseResponse
	PrePage        bool                      `json:"PrePage" xml:"PrePage"`
	CurrentPageNum int                       `json:"CurrentPageNum" xml:"CurrentPageNum"`
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	PageSize       int                       `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                       `json:"TotalPageNum" xml:"TotalPageNum"`
	TotalItemNum   int                       `json:"TotalItemNum" xml:"TotalItemNum"`
	NextPage       bool                      `json:"NextPage" xml:"NextPage"`
	Data           []QueryTransferInResponse `json:"Data" xml:"Data"`
}

// CreateListServerLockRequest creates a request to invoke ListServerLock API
func CreateListServerLockRequest() (request *ListServerLockRequest) {
	request = &ListServerLockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "ListServerLock", "", "")
	request.Method = requests.POST
	return
}

// CreateListServerLockResponse creates a response to parse from ListServerLock response
func CreateListServerLockResponse() (response *ListServerLockResponse) {
	response = &ListServerLockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
