package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateAxgGroup invokes the dyplsapi.OperateAxgGroup API synchronously
func (client *Client) OperateAxgGroup(request *OperateAxgGroupRequest) (response *OperateAxgGroupResponse, err error) {
	response = CreateOperateAxgGroupResponse()
	err = client.DoAction(request, response)
	return
}

// OperateAxgGroupWithChan invokes the dyplsapi.OperateAxgGroup API asynchronously
func (client *Client) OperateAxgGroupWithChan(request *OperateAxgGroupRequest) (<-chan *OperateAxgGroupResponse, <-chan error) {
	responseChan := make(chan *OperateAxgGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateAxgGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateAxgGroupWithCallback invokes the dyplsapi.OperateAxgGroup API asynchronously
func (client *Client) OperateAxgGroupWithCallback(request *OperateAxgGroupRequest, callback func(response *OperateAxgGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateAxgGroupResponse
		var err error
		defer close(result)
		response, err = client.OperateAxgGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateAxgGroupRequest is the request struct for api OperateAxgGroup
type OperateAxgGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Numbers              string           `position:"Query" name:"Numbers"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	GroupId              requests.Integer `position:"Query" name:"GroupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	OperateType          string           `position:"Query" name:"OperateType"`
}

// OperateAxgGroupResponse is the response struct for api OperateAxgGroup
type OperateAxgGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateAxgGroupRequest creates a request to invoke OperateAxgGroup API
func CreateOperateAxgGroupRequest() (request *OperateAxgGroupRequest) {
	request = &OperateAxgGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "OperateAxgGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateAxgGroupResponse creates a response to parse from OperateAxgGroup response
func CreateOperateAxgGroupResponse() (response *OperateAxgGroupResponse) {
	response = &OperateAxgGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
