package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneNumberOnlineTime invokes the dytnsapi.DescribePhoneNumberOnlineTime API synchronously
func (client *Client) DescribePhoneNumberOnlineTime(request *DescribePhoneNumberOnlineTimeRequest) (response *DescribePhoneNumberOnlineTimeResponse, err error) {
	response = CreateDescribePhoneNumberOnlineTimeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneNumberOnlineTimeWithChan invokes the dytnsapi.DescribePhoneNumberOnlineTime API asynchronously
func (client *Client) DescribePhoneNumberOnlineTimeWithChan(request *DescribePhoneNumberOnlineTimeRequest) (<-chan *DescribePhoneNumberOnlineTimeResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneNumberOnlineTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneNumberOnlineTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneNumberOnlineTimeWithCallback invokes the dytnsapi.DescribePhoneNumberOnlineTime API asynchronously
func (client *Client) DescribePhoneNumberOnlineTimeWithCallback(request *DescribePhoneNumberOnlineTimeRequest, callback func(response *DescribePhoneNumberOnlineTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneNumberOnlineTimeResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneNumberOnlineTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneNumberOnlineTimeRequest is the request struct for api DescribePhoneNumberOnlineTime
type DescribePhoneNumberOnlineTimeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	OfferType            string           `position:"Query" name:"OfferType"`
	ResultCount          requests.Integer `position:"Query" name:"ResultCount"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
	Carrier              string           `position:"Query" name:"Carrier"`
}

// DescribePhoneNumberOnlineTimeResponse is the response struct for api DescribePhoneNumberOnlineTime
type DescribePhoneNumberOnlineTimeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePhoneNumberOnlineTimeRequest creates a request to invoke DescribePhoneNumberOnlineTime API
func CreateDescribePhoneNumberOnlineTimeRequest() (request *DescribePhoneNumberOnlineTimeRequest) {
	request = &DescribePhoneNumberOnlineTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribePhoneNumberOnlineTime", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePhoneNumberOnlineTimeResponse creates a response to parse from DescribePhoneNumberOnlineTime response
func CreateDescribePhoneNumberOnlineTimeResponse() (response *DescribePhoneNumberOnlineTimeResponse) {
	response = &DescribePhoneNumberOnlineTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
