package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExtendCluster invokes the eflo_controller.ExtendCluster API synchronously
func (client *Client) ExtendCluster(request *ExtendClusterRequest) (response *ExtendClusterResponse, err error) {
	response = CreateExtendClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ExtendClusterWithChan invokes the eflo_controller.ExtendCluster API asynchronously
func (client *Client) ExtendClusterWithChan(request *ExtendClusterRequest) (<-chan *ExtendClusterResponse, <-chan error) {
	responseChan := make(chan *ExtendClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExtendCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExtendClusterWithCallback invokes the eflo_controller.ExtendCluster API asynchronously
func (client *Client) ExtendClusterWithCallback(request *ExtendClusterRequest, callback func(response *ExtendClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExtendClusterResponse
		var err error
		defer close(result)
		response, err = client.ExtendCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExtendClusterRequest is the request struct for api ExtendCluster
type ExtendClusterRequest struct {
	*requests.RpcRequest
	IgnoreFailedNodeTasks requests.Boolean           `position:"Body" name:"IgnoreFailedNodeTasks"`
	ClusterId             string                     `position:"Body" name:"ClusterId"`
	NodeGroups            *[]ExtendClusterNodeGroups `position:"Body" name:"NodeGroups"  type:"Json"`
}

// ExtendClusterNodeGroups is a repeated param struct in ExtendClusterRequest
type ExtendClusterNodeGroups struct {
	Nodes       *[]ExtendClusterNodeGroupsNodesItem `name:"Nodes" type:"Repeated"`
	NodeGroupId string                              `name:"NodeGroupId"`
}

// ExtendClusterNodeGroupsNodesItem is a repeated param struct in ExtendClusterRequest
type ExtendClusterNodeGroupsNodesItem struct {
	Hostname      string `name:"Hostname"`
	LoginPassword string `name:"LoginPassword"`
	NodeId        string `name:"NodeId"`
}

// ExtendClusterResponse is the response struct for api ExtendCluster
type ExtendClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateExtendClusterRequest creates a request to invoke ExtendCluster API
func CreateExtendClusterRequest() (request *ExtendClusterRequest) {
	request = &ExtendClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "ExtendCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateExtendClusterResponse creates a response to parse from ExtendCluster response
func CreateExtendClusterResponse() (response *ExtendClusterResponse) {
	response = &ExtendClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
