package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGWSCluster invokes the ehpc.CreateGWSCluster API synchronously
func (client *Client) CreateGWSCluster(request *CreateGWSClusterRequest) (response *CreateGWSClusterResponse, err error) {
	response = CreateCreateGWSClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGWSClusterWithChan invokes the ehpc.CreateGWSCluster API asynchronously
func (client *Client) CreateGWSClusterWithChan(request *CreateGWSClusterRequest) (<-chan *CreateGWSClusterResponse, <-chan error) {
	responseChan := make(chan *CreateGWSClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGWSCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGWSClusterWithCallback invokes the ehpc.CreateGWSCluster API asynchronously
func (client *Client) CreateGWSClusterWithCallback(request *CreateGWSClusterRequest, callback func(response *CreateGWSClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGWSClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateGWSCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGWSClusterRequest is the request struct for api CreateGWSCluster
type CreateGWSClusterRequest struct {
	*requests.RpcRequest
	ClusterType string `position:"Query" name:"ClusterType"`
	VSwitchId   string `position:"Query" name:"VSwitchId"`
	VpcId       string `position:"Query" name:"VpcId"`
	Name        string `position:"Query" name:"Name"`
}

// CreateGWSClusterResponse is the response struct for api CreateGWSCluster
type CreateGWSClusterResponse struct {
	*responses.BaseResponse
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateGWSClusterRequest creates a request to invoke CreateGWSCluster API
func CreateCreateGWSClusterRequest() (request *CreateGWSClusterRequest) {
	request = &CreateGWSClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "CreateGWSCluster", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateGWSClusterResponse creates a response to parse from CreateGWSCluster response
func CreateCreateGWSClusterResponse() (response *CreateGWSClusterResponse) {
	response = &CreateGWSClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
