package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUpgradeClients invokes the ehpc.ListUpgradeClients API synchronously
func (client *Client) ListUpgradeClients(request *ListUpgradeClientsRequest) (response *ListUpgradeClientsResponse, err error) {
	response = CreateListUpgradeClientsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUpgradeClientsWithChan invokes the ehpc.ListUpgradeClients API asynchronously
func (client *Client) ListUpgradeClientsWithChan(request *ListUpgradeClientsRequest) (<-chan *ListUpgradeClientsResponse, <-chan error) {
	responseChan := make(chan *ListUpgradeClientsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUpgradeClients(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUpgradeClientsWithCallback invokes the ehpc.ListUpgradeClients API asynchronously
func (client *Client) ListUpgradeClientsWithCallback(request *ListUpgradeClientsRequest, callback func(response *ListUpgradeClientsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUpgradeClientsResponse
		var err error
		defer close(result)
		response, err = client.ListUpgradeClients(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUpgradeClientsRequest is the request struct for api ListUpgradeClients
type ListUpgradeClientsRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// ListUpgradeClientsResponse is the response struct for api ListUpgradeClients
type ListUpgradeClientsResponse struct {
	*responses.BaseResponse
	RequestId      string              `json:"RequestId" xml:"RequestId"`
	LatestVersion  string              `json:"LatestVersion" xml:"LatestVersion"`
	CurrentVersion string              `json:"CurrentVersion" xml:"CurrentVersion"`
	ClientRecords  []ClientRecordsItem `json:"ClientRecords" xml:"ClientRecords"`
}

// CreateListUpgradeClientsRequest creates a request to invoke ListUpgradeClients API
func CreateListUpgradeClientsRequest() (request *ListUpgradeClientsRequest) {
	request = &ListUpgradeClientsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListUpgradeClients", "", "")
	request.Method = requests.GET
	return
}

// CreateListUpgradeClientsResponse creates a response to parse from ListUpgradeClients response
func CreateListUpgradeClientsResponse() (response *ListUpgradeClientsResponse) {
	response = &ListUpgradeClientsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
