package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SummaryImages invokes the ehpc.SummaryImages API synchronously
func (client *Client) SummaryImages(request *SummaryImagesRequest) (response *SummaryImagesResponse, err error) {
	response = CreateSummaryImagesResponse()
	err = client.DoAction(request, response)
	return
}

// SummaryImagesWithChan invokes the ehpc.SummaryImages API asynchronously
func (client *Client) SummaryImagesWithChan(request *SummaryImagesRequest) (<-chan *SummaryImagesResponse, <-chan error) {
	responseChan := make(chan *SummaryImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SummaryImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SummaryImagesWithCallback invokes the ehpc.SummaryImages API asynchronously
func (client *Client) SummaryImagesWithCallback(request *SummaryImagesRequest, callback func(response *SummaryImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SummaryImagesResponse
		var err error
		defer close(result)
		response, err = client.SummaryImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SummaryImagesRequest is the request struct for api SummaryImages
type SummaryImagesRequest struct {
	*requests.RpcRequest
	ClusterId     string `position:"Query" name:"ClusterId"`
	ContainerType string `position:"Query" name:"ContainerType"`
}

// SummaryImagesResponse is the response struct for api SummaryImages
type SummaryImagesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ImagesName string `json:"ImagesName" xml:"ImagesName"`
}

// CreateSummaryImagesRequest creates a request to invoke SummaryImages API
func CreateSummaryImagesRequest() (request *SummaryImagesRequest) {
	request = &SummaryImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "SummaryImages", "", "")
	request.Method = requests.GET
	return
}

// CreateSummaryImagesResponse creates a response to parse from SummaryImages response
func CreateSummaryImagesResponse() (response *SummaryImagesResponse) {
	response = &SummaryImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
