package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunInstances invokes the ens.RunInstances API synchronously
func (client *Client) RunInstances(request *RunInstancesRequest) (response *RunInstancesResponse, err error) {
	response = CreateRunInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// RunInstancesWithChan invokes the ens.RunInstances API asynchronously
func (client *Client) RunInstancesWithChan(request *RunInstancesRequest) (<-chan *RunInstancesResponse, <-chan error) {
	responseChan := make(chan *RunInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunInstancesWithCallback invokes the ens.RunInstances API asynchronously
func (client *Client) RunInstancesWithCallback(request *RunInstancesRequest, callback func(response *RunInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunInstancesResponse
		var err error
		defer close(result)
		response, err = client.RunInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunInstancesRequest is the request struct for api RunInstances
type RunInstancesRequest struct {
	*requests.RpcRequest
	ScheduleAreaLevel       string                  `position:"Query" name:"ScheduleAreaLevel"`
	UniqueSuffix            requests.Boolean        `position:"Query" name:"UniqueSuffix"`
	SecurityId              string                  `position:"Query" name:"SecurityId"`
	KeyPairName             string                  `position:"Query" name:"KeyPairName"`
	Password                string                  `position:"Query" name:"Password"`
	HostName                string                  `position:"Query" name:"HostName"`
	SystemDisk              RunInstancesSystemDisk  `position:"Query" name:"SystemDisk"  type:"Struct"`
	NetDistrictCode         string                  `position:"Query" name:"NetDistrictCode"`
	EnsRegionId             string                  `position:"Query" name:"EnsRegionId"`
	Period                  requests.Integer        `position:"Query" name:"Period"`
	PublicIpIdentification  requests.Boolean        `position:"Query" name:"PublicIpIdentification"`
	VSwitchId               string                  `position:"Query" name:"VSwitchId"`
	PrivateIpAddress        string                  `position:"Query" name:"PrivateIpAddress"`
	PeriodUnit              string                  `position:"Query" name:"PeriodUnit"`
	InstanceName            string                  `position:"Query" name:"InstanceName"`
	AutoRenew               requests.Boolean        `position:"Query" name:"AutoRenew"`
	InternetChargeType      string                  `position:"Query" name:"InternetChargeType"`
	NetWorkId               string                  `position:"Query" name:"NetWorkId"`
	SchedulingPriceStrategy string                  `position:"Query" name:"SchedulingPriceStrategy"`
	ImageId                 string                  `position:"Query" name:"ImageId"`
	InternetMaxBandwidthOut requests.Integer        `position:"Query" name:"InternetMaxBandwidthOut"`
	UserData                string                  `position:"Query" name:"UserData"`
	InstanceType            string                  `position:"Query" name:"InstanceType"`
	InstanceChargeType      string                  `position:"Query" name:"InstanceChargeType"`
	Amount                  requests.Integer        `position:"Query" name:"Amount"`
	DataDisk                *[]RunInstancesDataDisk `position:"Query" name:"DataDisk"  type:"Json"`
	SchedulingStrategy      string                  `position:"Query" name:"SchedulingStrategy"`
	Carrier                 string                  `position:"Query" name:"Carrier"`
}

// RunInstancesDataDisk is a repeated param struct in RunInstancesRequest
type RunInstancesDataDisk struct {
	Size     string `name:"Size"`
	Category string `name:"Category"`
}

// RunInstancesSystemDisk is a repeated param struct in RunInstancesRequest
type RunInstancesSystemDisk struct {
	Size string `name:"Size"`
}

// RunInstancesResponse is the response struct for api RunInstances
type RunInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	OrderId     string   `json:"OrderId" xml:"OrderId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateRunInstancesRequest creates a request to invoke RunInstances API
func CreateRunInstancesRequest() (request *RunInstancesRequest) {
	request = &RunInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RunInstances", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunInstancesResponse creates a response to parse from RunInstances response
func CreateRunInstancesResponse() (response *RunInstancesResponse) {
	response = &RunInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
