package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCasterConfig invokes the live.DescribeCasterConfig API synchronously
func (client *Client) DescribeCasterConfig(request *DescribeCasterConfigRequest) (response *DescribeCasterConfigResponse, err error) {
	response = CreateDescribeCasterConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCasterConfigWithChan invokes the live.DescribeCasterConfig API asynchronously
func (client *Client) DescribeCasterConfigWithChan(request *DescribeCasterConfigRequest) (<-chan *DescribeCasterConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeCasterConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCasterConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCasterConfigWithCallback invokes the live.DescribeCasterConfig API asynchronously
func (client *Client) DescribeCasterConfigWithCallback(request *DescribeCasterConfigRequest, callback func(response *DescribeCasterConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCasterConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeCasterConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCasterConfigRequest is the request struct for api DescribeCasterConfig
type DescribeCasterConfigRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCasterConfigResponse is the response struct for api DescribeCasterConfig
type DescribeCasterConfigResponse struct {
	*responses.BaseResponse
	Delay               float64          `json:"Delay" xml:"Delay"`
	UrgentLiveStreamUrl string           `json:"UrgentLiveStreamUrl" xml:"UrgentLiveStreamUrl"`
	UrgentMaterialId    string           `json:"UrgentMaterialId" xml:"UrgentMaterialId"`
	CallbackUrl         string           `json:"CallbackUrl" xml:"CallbackUrl"`
	ProgramName         string           `json:"ProgramName" xml:"ProgramName"`
	CasterName          string           `json:"CasterName" xml:"CasterName"`
	CasterId            string           `json:"CasterId" xml:"CasterId"`
	ProgramEffect       int              `json:"ProgramEffect" xml:"ProgramEffect"`
	ChannelEnable       int              `json:"ChannelEnable" xml:"ChannelEnable"`
	DomainName          string           `json:"DomainName" xml:"DomainName"`
	RequestId           string           `json:"RequestId" xml:"RequestId"`
	SideOutputUrlList   string           `json:"SideOutputUrlList" xml:"SideOutputUrlList"`
	SideOutputUrl       string           `json:"SideOutputUrl" xml:"SideOutputUrl"`
	TranscodeConfig     TranscodeConfig  `json:"TranscodeConfig" xml:"TranscodeConfig"`
	RecordConfig        RecordConfig     `json:"RecordConfig" xml:"RecordConfig"`
	SyncGroupsConfig    SyncGroupsConfig `json:"SyncGroupsConfig" xml:"SyncGroupsConfig"`
}

// CreateDescribeCasterConfigRequest creates a request to invoke DescribeCasterConfig API
func CreateDescribeCasterConfigRequest() (request *DescribeCasterConfigRequest) {
	request = &DescribeCasterConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeCasterConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCasterConfigResponse creates a response to parse from DescribeCasterConfig response
func CreateDescribeCasterConfigResponse() (response *DescribeCasterConfigResponse) {
	response = &DescribeCasterConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
