package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveProducerUsageData invokes the live.DescribeLiveProducerUsageData API synchronously
func (client *Client) DescribeLiveProducerUsageData(request *DescribeLiveProducerUsageDataRequest) (response *DescribeLiveProducerUsageDataResponse, err error) {
	response = CreateDescribeLiveProducerUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveProducerUsageDataWithChan invokes the live.DescribeLiveProducerUsageData API asynchronously
func (client *Client) DescribeLiveProducerUsageDataWithChan(request *DescribeLiveProducerUsageDataRequest) (<-chan *DescribeLiveProducerUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveProducerUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveProducerUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveProducerUsageDataWithCallback invokes the live.DescribeLiveProducerUsageData API asynchronously
func (client *Client) DescribeLiveProducerUsageDataWithCallback(request *DescribeLiveProducerUsageDataRequest, callback func(response *DescribeLiveProducerUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveProducerUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveProducerUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveProducerUsageDataRequest is the request struct for api DescribeLiveProducerUsageData
type DescribeLiveProducerUsageDataRequest struct {
	*requests.RpcRequest
	Instance   string           `position:"Query" name:"Instance"`
	StartTime  string           `position:"Query" name:"StartTime"`
	Type       string           `position:"Query" name:"Type"`
	SplitBy    string           `position:"Query" name:"SplitBy"`
	App        string           `position:"Query" name:"app"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
	Region     string           `position:"Query" name:"Region"`
}

// DescribeLiveProducerUsageDataResponse is the response struct for api DescribeLiveProducerUsageData
type DescribeLiveProducerUsageDataResponse struct {
	*responses.BaseResponse
	EndTime          string           `json:"EndTime" xml:"EndTime"`
	StartTime        string           `json:"StartTime" xml:"StartTime"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	BillProducerData BillProducerData `json:"BillProducerData" xml:"BillProducerData"`
}

// CreateDescribeLiveProducerUsageDataRequest creates a request to invoke DescribeLiveProducerUsageData API
func CreateDescribeLiveProducerUsageDataRequest() (request *DescribeLiveProducerUsageDataRequest) {
	request = &DescribeLiveProducerUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveProducerUsageData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveProducerUsageDataResponse creates a response to parse from DescribeLiveProducerUsageData response
func CreateDescribeLiveProducerUsageDataResponse() (response *DescribeLiveProducerUsageDataResponse) {
	response = &DescribeLiveProducerUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
