package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRTSNativeSDKPlayTime invokes the live.DescribeRTSNativeSDKPlayTime API synchronously
func (client *Client) DescribeRTSNativeSDKPlayTime(request *DescribeRTSNativeSDKPlayTimeRequest) (response *DescribeRTSNativeSDKPlayTimeResponse, err error) {
	response = CreateDescribeRTSNativeSDKPlayTimeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRTSNativeSDKPlayTimeWithChan invokes the live.DescribeRTSNativeSDKPlayTime API asynchronously
func (client *Client) DescribeRTSNativeSDKPlayTimeWithChan(request *DescribeRTSNativeSDKPlayTimeRequest) (<-chan *DescribeRTSNativeSDKPlayTimeResponse, <-chan error) {
	responseChan := make(chan *DescribeRTSNativeSDKPlayTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRTSNativeSDKPlayTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRTSNativeSDKPlayTimeWithCallback invokes the live.DescribeRTSNativeSDKPlayTime API asynchronously
func (client *Client) DescribeRTSNativeSDKPlayTimeWithCallback(request *DescribeRTSNativeSDKPlayTimeRequest, callback func(response *DescribeRTSNativeSDKPlayTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRTSNativeSDKPlayTimeResponse
		var err error
		defer close(result)
		response, err = client.DescribeRTSNativeSDKPlayTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRTSNativeSDKPlayTimeRequest is the request struct for api DescribeRTSNativeSDKPlayTime
type DescribeRTSNativeSDKPlayTimeRequest struct {
	*requests.RpcRequest
	EndTime        string    `position:"Query" name:"EndTime"`
	DomainNameList *[]string `position:"Query" name:"DomainNameList"  type:"Json"`
	StartTime      string    `position:"Query" name:"StartTime"`
	DataInterval   string    `position:"Query" name:"DataInterval"`
}

// DescribeRTSNativeSDKPlayTimeResponse is the response struct for api DescribeRTSNativeSDKPlayTime
type DescribeRTSNativeSDKPlayTimeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DataInterval string `json:"DataInterval" xml:"DataInterval"`
	StartTime    string `json:"StartTime" xml:"StartTime"`
	EndTime      string `json:"EndTime" xml:"EndTime"`
	PlayTimeData []Data `json:"PlayTimeData" xml:"PlayTimeData"`
}

// CreateDescribeRTSNativeSDKPlayTimeRequest creates a request to invoke DescribeRTSNativeSDKPlayTime API
func CreateDescribeRTSNativeSDKPlayTimeRequest() (request *DescribeRTSNativeSDKPlayTimeRequest) {
	request = &DescribeRTSNativeSDKPlayTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeRTSNativeSDKPlayTime", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRTSNativeSDKPlayTimeResponse creates a response to parse from DescribeRTSNativeSDKPlayTime response
func CreateDescribeRTSNativeSDKPlayTimeResponse() (response *DescribeRTSNativeSDKPlayTimeResponse) {
	response = &DescribeRTSNativeSDKPlayTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
