package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncPredict invokes the nlp_automl.GetAsyncPredict API synchronously
func (client *Client) GetAsyncPredict(request *GetAsyncPredictRequest) (response *GetAsyncPredictResponse, err error) {
	response = CreateGetAsyncPredictResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncPredictWithChan invokes the nlp_automl.GetAsyncPredict API asynchronously
func (client *Client) GetAsyncPredictWithChan(request *GetAsyncPredictRequest) (<-chan *GetAsyncPredictResponse, <-chan error) {
	responseChan := make(chan *GetAsyncPredictResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncPredict(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncPredictWithCallback invokes the nlp_automl.GetAsyncPredict API asynchronously
func (client *Client) GetAsyncPredictWithCallback(request *GetAsyncPredictRequest, callback func(response *GetAsyncPredictResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncPredictResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncPredict(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncPredictRequest is the request struct for api GetAsyncPredict
type GetAsyncPredictRequest struct {
	*requests.RpcRequest
	Product        string           `position:"Query" name:"Product"`
	AsyncPredictId requests.Integer `position:"Query" name:"AsyncPredictId"`
}

// GetAsyncPredictResponse is the response struct for api GetAsyncPredict
type GetAsyncPredictResponse struct {
	*responses.BaseResponse
	AsyncPredictId int    `json:"AsyncPredictId" xml:"AsyncPredictId"`
	Status         int    `json:"Status" xml:"Status"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Content        string `json:"Content" xml:"Content"`
}

// CreateGetAsyncPredictRequest creates a request to invoke GetAsyncPredict API
func CreateGetAsyncPredictRequest() (request *GetAsyncPredictRequest) {
	request = &GetAsyncPredictRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "GetAsyncPredict", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAsyncPredictResponse creates a response to parse from GetAsyncPredict response
func CreateGetAsyncPredictResponse() (response *GetAsyncPredictResponse) {
	response = &GetAsyncPredictResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
