package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFunctionModule invokes the retailadvqa_public.QueryFunctionModule API synchronously
func (client *Client) QueryFunctionModule(request *QueryFunctionModuleRequest) (response *QueryFunctionModuleResponse, err error) {
	response = CreateQueryFunctionModuleResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFunctionModuleWithChan invokes the retailadvqa_public.QueryFunctionModule API asynchronously
func (client *Client) QueryFunctionModuleWithChan(request *QueryFunctionModuleRequest) (<-chan *QueryFunctionModuleResponse, <-chan error) {
	responseChan := make(chan *QueryFunctionModuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFunctionModule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFunctionModuleWithCallback invokes the retailadvqa_public.QueryFunctionModule API asynchronously
func (client *Client) QueryFunctionModuleWithCallback(request *QueryFunctionModuleRequest, callback func(response *QueryFunctionModuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFunctionModuleResponse
		var err error
		defer close(result)
		response, err = client.QueryFunctionModule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFunctionModuleRequest is the request struct for api QueryFunctionModule
type QueryFunctionModuleRequest struct {
	*requests.RpcRequest
	AccessId string `position:"Query" name:"AccessId"`
	TenantId string `position:"Query" name:"TenantId"`
}

// QueryFunctionModuleResponse is the response struct for api QueryFunctionModule
type QueryFunctionModuleResponse struct {
	*responses.BaseResponse
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ExStack   string `json:"ExStack" xml:"ExStack"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryFunctionModuleRequest creates a request to invoke QueryFunctionModule API
func CreateQueryFunctionModuleRequest() (request *QueryFunctionModuleRequest) {
	request = &QueryFunctionModuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "QueryFunctionModule", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryFunctionModuleResponse creates a response to parse from QueryFunctionModule response
func CreateQueryFunctionModuleResponse() (response *QueryFunctionModuleResponse) {
	response = &QueryFunctionModuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
