package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchDirectories invokes the retailadvqa_public.SearchDirectories API synchronously
func (client *Client) SearchDirectories(request *SearchDirectoriesRequest) (response *SearchDirectoriesResponse, err error) {
	response = CreateSearchDirectoriesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchDirectoriesWithChan invokes the retailadvqa_public.SearchDirectories API asynchronously
func (client *Client) SearchDirectoriesWithChan(request *SearchDirectoriesRequest) (<-chan *SearchDirectoriesResponse, <-chan error) {
	responseChan := make(chan *SearchDirectoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchDirectories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchDirectoriesWithCallback invokes the retailadvqa_public.SearchDirectories API asynchronously
func (client *Client) SearchDirectoriesWithCallback(request *SearchDirectoriesRequest, callback func(response *SearchDirectoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchDirectoriesResponse
		var err error
		defer close(result)
		response, err = client.SearchDirectories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchDirectoriesRequest is the request struct for api SearchDirectories
type SearchDirectoriesRequest struct {
	*requests.RpcRequest
	AccessId          string           `position:"Query" name:"AccessId"`
	ParentDirectoryId string           `position:"Query" name:"ParentDirectoryId"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	DirectoryName     string           `position:"Query" name:"DirectoryName"`
	Type              requests.Integer `position:"Query" name:"Type"`
	PageNum           requests.Integer `position:"Query" name:"PageNum"`
	WorkspaceId       string           `position:"Query" name:"WorkspaceId"`
}

// SearchDirectoriesResponse is the response struct for api SearchDirectories
type SearchDirectoriesResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	ErrorDesc string                  `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string                  `json:"TraceId" xml:"TraceId"`
	ErrorCode string                  `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool                    `json:"Success" xml:"Success"`
	Data      DataInSearchDirectories `json:"Data" xml:"Data"`
}

// CreateSearchDirectoriesRequest creates a request to invoke SearchDirectories API
func CreateSearchDirectoriesRequest() (request *SearchDirectoriesRequest) {
	request = &SearchDirectoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "SearchDirectories", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchDirectoriesResponse creates a response to parse from SearchDirectories response
func CreateSearchDirectoriesResponse() (response *SearchDirectoriesResponse) {
	response = &SearchDirectoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
