package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCommonOverallConfig invokes the sas.DescribeCommonOverallConfig API synchronously
func (client *Client) DescribeCommonOverallConfig(request *DescribeCommonOverallConfigRequest) (response *DescribeCommonOverallConfigResponse, err error) {
	response = CreateDescribeCommonOverallConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCommonOverallConfigWithChan invokes the sas.DescribeCommonOverallConfig API asynchronously
func (client *Client) DescribeCommonOverallConfigWithChan(request *DescribeCommonOverallConfigRequest) (<-chan *DescribeCommonOverallConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeCommonOverallConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCommonOverallConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCommonOverallConfigWithCallback invokes the sas.DescribeCommonOverallConfig API asynchronously
func (client *Client) DescribeCommonOverallConfigWithCallback(request *DescribeCommonOverallConfigRequest, callback func(response *DescribeCommonOverallConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCommonOverallConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeCommonOverallConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCommonOverallConfigRequest is the request struct for api DescribeCommonOverallConfig
type DescribeCommonOverallConfigRequest struct {
	*requests.RpcRequest
	Type                       string `position:"Query" name:"Type"`
	SourceIp                   string `position:"Query" name:"SourceIp"`
	ResourceDirectoryAccountId string `position:"Query" name:"ResourceDirectoryAccountId"`
}

// DescribeCommonOverallConfigResponse is the response struct for api DescribeCommonOverallConfig
type DescribeCommonOverallConfigResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	OverallConfig OverallConfig `json:"OverallConfig" xml:"OverallConfig"`
}

// CreateDescribeCommonOverallConfigRequest creates a request to invoke DescribeCommonOverallConfig API
func CreateDescribeCommonOverallConfigRequest() (request *DescribeCommonOverallConfigRequest) {
	request = &DescribeCommonOverallConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeCommonOverallConfig", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCommonOverallConfigResponse creates a response to parse from DescribeCommonOverallConfig response
func CreateDescribeCommonOverallConfigResponse() (response *DescribeCommonOverallConfigResponse) {
	response = &DescribeCommonOverallConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
