package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagPortRole invokes the smartag.ModifySagPortRole API synchronously
func (client *Client) ModifySagPortRole(request *ModifySagPortRoleRequest) (response *ModifySagPortRoleResponse, err error) {
	response = CreateModifySagPortRoleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagPortRoleWithChan invokes the smartag.ModifySagPortRole API asynchronously
func (client *Client) ModifySagPortRoleWithChan(request *ModifySagPortRoleRequest) (<-chan *ModifySagPortRoleResponse, <-chan error) {
	responseChan := make(chan *ModifySagPortRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagPortRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagPortRoleWithCallback invokes the smartag.ModifySagPortRole API asynchronously
func (client *Client) ModifySagPortRoleWithCallback(request *ModifySagPortRoleRequest, callback func(response *ModifySagPortRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagPortRoleResponse
		var err error
		defer close(result)
		response, err = client.ModifySagPortRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagPortRoleRequest is the request struct for api ModifySagPortRole
type ModifySagPortRoleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Role                 string           `position:"Query" name:"Role"`
	Vlan                 string           `position:"Query" name:"Vlan"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	PortName             string           `position:"Query" name:"PortName"`
}

// ModifySagPortRoleResponse is the response struct for api ModifySagPortRole
type ModifySagPortRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagPortRoleRequest creates a request to invoke ModifySagPortRole API
func CreateModifySagPortRoleRequest() (request *ModifySagPortRoleRequest) {
	request = &ModifySagPortRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagPortRole", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagPortRoleResponse creates a response to parse from ModifySagPortRole response
func CreateModifySagPortRoleResponse() (response *ModifySagPortRoleResponse) {
	response = &ModifySagPortRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
