package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpnConnectionLogs invokes the vpc.DescribeVpnConnectionLogs API synchronously
func (client *Client) DescribeVpnConnectionLogs(request *DescribeVpnConnectionLogsRequest) (response *DescribeVpnConnectionLogsResponse, err error) {
	response = CreateDescribeVpnConnectionLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpnConnectionLogsWithChan invokes the vpc.DescribeVpnConnectionLogs API asynchronously
func (client *Client) DescribeVpnConnectionLogsWithChan(request *DescribeVpnConnectionLogsRequest) (<-chan *DescribeVpnConnectionLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeVpnConnectionLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpnConnectionLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpnConnectionLogsWithCallback invokes the vpc.DescribeVpnConnectionLogs API asynchronously
func (client *Client) DescribeVpnConnectionLogsWithCallback(request *DescribeVpnConnectionLogsRequest, callback func(response *DescribeVpnConnectionLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpnConnectionLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpnConnectionLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpnConnectionLogsRequest is the request struct for api DescribeVpnConnectionLogs
type DescribeVpnConnectionLogsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	MinutePeriod         requests.Integer `position:"Query" name:"MinutePeriod"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	From                 requests.Integer `position:"Query" name:"From"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
	To                   requests.Integer `position:"Query" name:"To"`
}

// DescribeVpnConnectionLogsResponse is the response struct for api DescribeVpnConnectionLogs
type DescribeVpnConnectionLogsResponse struct {
	*responses.BaseResponse
	PageSize    int                             `json:"PageSize" xml:"PageSize"`
	PageNumber  int                             `json:"PageNumber" xml:"PageNumber"`
	RequestId   string                          `json:"RequestId" xml:"RequestId"`
	Count       int                             `json:"Count" xml:"Count"`
	IsCompleted bool                            `json:"IsCompleted" xml:"IsCompleted"`
	Data        DataInDescribeVpnConnectionLogs `json:"Data" xml:"Data"`
}

// CreateDescribeVpnConnectionLogsRequest creates a request to invoke DescribeVpnConnectionLogs API
func CreateDescribeVpnConnectionLogsRequest() (request *DescribeVpnConnectionLogsRequest) {
	request = &DescribeVpnConnectionLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeVpnConnectionLogs", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpnConnectionLogsResponse creates a response to parse from DescribeVpnConnectionLogs response
func CreateDescribeVpnConnectionLogsResponse() (response *DescribeVpnConnectionLogsResponse) {
	response = &DescribeVpnConnectionLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
