package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTransferStream invokes the vs.StopTransferStream API synchronously
func (client *Client) StopTransferStream(request *StopTransferStreamRequest) (response *StopTransferStreamResponse, err error) {
	response = CreateStopTransferStreamResponse()
	err = client.DoAction(request, response)
	return
}

// StopTransferStreamWithChan invokes the vs.StopTransferStream API asynchronously
func (client *Client) StopTransferStreamWithChan(request *StopTransferStreamRequest) (<-chan *StopTransferStreamResponse, <-chan error) {
	responseChan := make(chan *StopTransferStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTransferStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTransferStreamWithCallback invokes the vs.StopTransferStream API asynchronously
func (client *Client) StopTransferStreamWithCallback(request *StopTransferStreamRequest, callback func(response *StopTransferStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTransferStreamResponse
		var err error
		defer close(result)
		response, err = client.StopTransferStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTransferStreamRequest is the request struct for api StopTransferStream
type StopTransferStreamRequest struct {
	*requests.RpcRequest
	Id        string           `position:"Query" name:"Id"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	Transcode string           `position:"Query" name:"Transcode"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// StopTransferStreamResponse is the response struct for api StopTransferStream
type StopTransferStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopTransferStreamRequest creates a request to invoke StopTransferStream API
func CreateStopTransferStreamRequest() (request *StopTransferStreamRequest) {
	request = &StopTransferStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StopTransferStream", "", "")
	request.Method = requests.POST
	return
}

// CreateStopTransferStreamResponse creates a response to parse from StopTransferStream response
func CreateStopTransferStreamResponse() (response *StopTransferStreamResponse) {
	response = &StopTransferStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
